/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.localization;

import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class LocalizationServiceHelper {
    private static LocalizationServiceHelper instance;
    private final BundleContext bundleContext = FrameworkUtil.getBundle(LocalizationServiceHelper.class).getBundleContext();

    private static LocalizationServiceHelper getInstance() {
        if (instance == null) {
            instance = new LocalizationServiceHelper();
        }
        return instance;
    }

    private LocalizationServiceHelper() {
    }

    private String innerGetString(Bundle bundle, String key) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(EMFFormsLocalizationService.class);
        if (serviceReference == null) {
            return null;
        }
        EMFFormsLocalizationService localeProvider = (EMFFormsLocalizationService)this.bundleContext.getService(serviceReference);
        String result = localeProvider.getString(bundle, key);
        this.bundleContext.ungetService(serviceReference);
        return result;
    }

    private String innerGetString(Class<?> clazz, String key) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(EMFFormsLocalizationService.class);
        if (serviceReference == null) {
            return null;
        }
        EMFFormsLocalizationService localeProvider = (EMFFormsLocalizationService)this.bundleContext.getService(serviceReference);
        String result = localeProvider.getString(clazz, key);
        this.bundleContext.ungetService(serviceReference);
        return result;
    }

    public static String getString(Bundle bundle, String key) {
        return LocalizationServiceHelper.getInstance().innerGetString(bundle, key);
    }

    public static String getString(Class<?> clazz, String key) {
        return LocalizationServiceHelper.getInstance().innerGetString(clazz, key);
    }
}

