/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.DomainModelReferenceControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.label.model.VLabelPackage;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackPackage;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="DomainModelReferenceControlSWTRendererService")
public class DomainModelReferenceControlSWTRendererService
implements EMFFormsDIRendererService<VControl> {
    private EMFFormsDatabinding databindingService;
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = databindingService;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return Double.NaN;
        }
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        return this.isApplicable((EStructuralFeature)valueProperty.getValueType());
    }

    private double isApplicable(EStructuralFeature feature) {
        if (VViewPackage.eINSTANCE.getControl_DomainModelReference() == feature) {
            return 3.0;
        }
        if (VLabelPackage.eINSTANCE.getLabel_DomainModelReference() == feature) {
            return 3.0;
        }
        if (VStackPackage.eINSTANCE.getStackLayout_DomainModelReference() == feature) {
            return 3.0;
        }
        if (VTablePackage.eINSTANCE.getTableDomainModelReference_DomainModelReference() == feature) {
            return 3.0;
        }
        if (RulePackage.Literals.LEAF_CONDITION__DOMAIN_MODEL_REFERENCE == feature) {
            return 3.0;
        }
        return Double.NaN;
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return DomainModelReferenceControlSWTRenderer.class;
    }
}

