/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.simple;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="makeContainment", label="Make Reference Containment", description="In the metamodel, a reference is made containment. In the model, its values are replaced by copies.", breaking=true)
public class MakeContainment
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference")
    public EReference reference;

    @EdaptConstraint(restricts="reference", description="The reference must not already be containment.")
    public boolean checkReferenceNotContainment(EReference reference) {
        return !reference.isContainment();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass contextClass = this.reference.getEContainingClass();
        this.reference.setContainment(true);
        for (Instance instance : model.getAllInstances(contextClass)) {
            if (this.reference.isMany()) {
                List values = (List)instance.unset((EStructuralFeature)this.reference);
                for (Instance value : values) {
                    instance.add((EStructuralFeature)this.reference, (Object)value.copy());
                }
                continue;
            }
            Instance value = (Instance)instance.unset((EStructuralFeature)this.reference);
            if (value == null) continue;
            instance.set((EStructuralFeature)this.reference, (Object)value.copy());
        }
    }
}

