/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.changebroker.spi;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.changebroker.spi.NotificationProvider;
import org.eclipse.emf.ecp.changebroker.spi.NotificationReceiver;

public abstract class AbstractNotificationProvider
implements NotificationProvider {
    private final Set<NotificationReceiver> receivers = new CopyOnWriteArraySet<NotificationReceiver>();

    @Override
    public void addReceiver(NotificationReceiver receiver) {
        this.receivers.add(receiver);
    }

    @Override
    public void removeReceiver(NotificationReceiver receiver) {
        this.receivers.remove(receiver);
    }

    protected void notifyAllReceivers(Notification notification) {
        for (NotificationReceiver receiver : this.receivers) {
            receiver.notify(notification);
        }
    }

    protected void notifyPreDelete(EObject toBeDeleted) {
        for (NotificationReceiver receiver : this.receivers) {
            receiver.notifyPreDelete(toBeDeleted);
        }
    }

    protected void notifyPostDelete(EObject toBeDeleted) {
        for (NotificationReceiver receiver : this.receivers) {
            receiver.notifyPostDelete(toBeDeleted);
        }
    }

    protected boolean notifyCanDelete(EObject toBeDeleted) {
        boolean canDelete = true;
        for (NotificationReceiver receiver : this.receivers) {
            canDelete = receiver.canDelete(toBeDeleted);
            if (!canDelete) break;
        }
        return canDelete;
    }
}

