/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db;

import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.dirigible.repository.logging.Logger;

public class SimpleCacheManager {
    private static final Logger logger = Logger.getLogger(SimpleCacheManager.class);
    private static final long MAX_EXPIRATION_TIME = 10000L;
    private Map<String, ExpirationWrapper> cache = Collections.synchronizedMap(new WeakHashMap());
    private boolean disabled = true;

    public SimpleCacheManager(boolean disableCache) {
        this.disabled = disableCache;
    }

    public void put(String cacheKey, Object value) {
        if (!this.isDisabled() && value != null && this.cache.get(cacheKey) == null) {
            logger.debug("put: " + cacheKey + " value: " + value);
            ExpirationWrapper wrapper = new ExpirationWrapper(value, GregorianCalendar.getInstance().getTime().getTime());
            this.cache.put(cacheKey, wrapper);
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Object get(String cacheKey) {
        ExpirationWrapper wrapper = this.cache.get(cacheKey);
        if (wrapper != null) {
            if (GregorianCalendar.getInstance().getTime().getTime() - wrapper.getCreated() < 10000L) {
                logger.debug("cache used for: " + cacheKey);
                return wrapper.value;
            }
            logger.debug("cache expired for: " + cacheKey);
            this.clear(cacheKey);
        }
        return null;
    }

    public void clear(String cacheKey) {
        this.cache.remove(cacheKey);
    }

    public void clear() {
        this.cache.clear();
    }

    class ExpirationWrapper {
        private Object value;
        private long created;

        ExpirationWrapper(Object value, long created) {
            this.value = value;
            this.created = created;
        }

        public Object getValue() {
            return this.value;
        }

        public long getCreated() {
            return this.created;
        }
    }
}

