/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.datasource.db.dialect.RDBGenericDialectSpecifier;

public class PostgreSQLDBSpecifier
extends RDBGenericDialectSpecifier {
    public static final String PRODUCT_POSTGRESQL = "PostgreSQL";
    private static final String LIMIT_D_OFFSET_D = "LIMIT %d OFFSET %d";
    private static final String POSTGRESQL_TIMESTAMP = "TIMESTAMP";
    private static final String POSTGRESQL_FLOAT = "REAL";
    private static final String POSTGRESQL_DOUBLE = "DOUBLE PRECISION";
    private static final String POSTGRESQL_BLOB = "BYTEA";
    private static final String POSTGRESQL_CLOB = "TEXT";
    private static final String POSTGRESQL_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private static final String POSTGRESQL_KEY_VARCHAR = "VARCHAR(1000)";
    private static final String POSTGRESQL_BIG_VARCHAR = "VARCHAR(4000)";

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_OFFSET_D, limit, offset);
    }

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", POSTGRESQL_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", POSTGRESQL_TIMESTAMP);
        sql = sql.replace("$BLOB$", POSTGRESQL_BLOB);
        sql = sql.replace("$KEY_VARCHAR$", POSTGRESQL_KEY_VARCHAR);
        sql = sql.replace("$BIG_VARCHAR$", POSTGRESQL_BIG_VARCHAR);
        sql = sql.replace("$CLOB$", POSTGRESQL_CLOB);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return POSTGRESQL_FLOAT;
        }
        if ("DOUBLE".equals(commonType)) {
            return POSTGRESQL_DOUBLE;
        }
        if ("BLOB".equals(commonType)) {
            return POSTGRESQL_BLOB;
        }
        if ("CLOB".equals(commonType)) {
            return POSTGRESQL_CLOB;
        }
        return commonType;
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        return new ByteArrayInputStream(resultSet.getBytes(columnName));
    }

    @Override
    public String getAlterAddOpenEach() {
        return " ADD COLUMN ";
    }

    @Override
    public boolean isDialectForName(String productName) {
        return PRODUCT_POSTGRESQL.equalsIgnoreCase(productName);
    }
}

