/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.ext.fs.FileSystemUtils;
import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.LocalEntity;
import org.eclipse.dirigible.repository.local.LocalFile;
import org.eclipse.dirigible.repository.local.LocalObject;
import org.eclipse.dirigible.repository.local.LocalWorkspaceMapper;
import org.eclipse.dirigible.repository.local.Messages;
import org.eclipse.dirigible.repository.logging.Logger;

public class LocalResource
extends LocalEntity
implements IResource {
    private static final String THERE_IS_NO_RESOURCE_AT_PATH_0 = Messages.getString("DBResource.THERE_IS_NO_RESOURCE_AT_PATH_0");
    private static final String COULD_NOT_UPDATE_DOCUMENT = Messages.getString("DBResource.COULD_NOT_UPDATE_DOCUMENT");
    private static final String COULD_NOT_READ_RESOURCE_CONTENT = Messages.getString("DBResource.COULD_NOT_READ_RESOURCE_CONTENT");
    private static final String NOT_IMPLEMENTED = Messages.getString("DBResource.NOT_IMPLEMENTED");
    private static final String COULD_NOT_DELETE_RESOURCE = Messages.getString("DBResource.COULD_NOT_DELETE_RESOURCE");
    private static final String COULD_NOT_RENAME_RESOURCE = Messages.getString("DBResource.COULD_NOT_RENAME_RESOURCE");
    private static final Logger logger = Logger.getLogger(LocalResource.class);
    private boolean binary = false;
    private String contentType;

    public LocalResource(FileSystemRepository repository, RepositoryPath path) {
        super(repository, path);
        try {
            LocalFile localFile = this.getDocument();
            if (localFile != null) {
                this.binary = localFile.isBinary();
                this.contentType = localFile.getContentType();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void create() throws IOException {
        this.getParent().createResource(this.getName(), null, false, "text/plain");
    }

    public void delete() throws IOException {
        LocalFile document = this.getDocumentSafe();
        try {
            document.delete();
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_DELETE_RESOURCE) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void renameTo(String name) throws IOException {
        LocalFile document = this.getDocumentSafe();
        try {
            document.rename(RepositoryPath.normalizePath((String)this.getParent().getPath(), (String)name));
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_RESOURCE) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void moveTo(String path) throws IOException {
        LocalFile document = this.getDocumentSafe();
        try {
            document.rename(path);
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_RESOURCE) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void copyTo(String path) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    public boolean exists() throws IOException {
        String repositoryPath = this.getRepositoryPath().toString();
        String localPath = LocalWorkspaceMapper.getMappedName(this.getRepository(), repositoryPath);
        return FileSystemUtils.fileExists((String)localPath);
    }

    public boolean isEmpty() throws IOException {
        return this.getContent().length == 0;
    }

    public byte[] getContent() throws IOException {
        LocalFile document = this.getDocumentSafe();
        try {
            byte[] bytes = document.getData();
            return bytes;
        }
        catch (LocalBaseException ex) {
            throw new IOException(COULD_NOT_READ_RESOURCE_CONTENT, (Throwable)((Object)ex));
        }
    }

    public void setContent(byte[] content) throws IOException {
        if (this.contentType == null || "".equals(this.contentType)) {
            this.contentType = "text/plain";
        }
        if (this.exists()) {
            LocalFile document = this.getDocumentSafe();
            try {
                document.setData(content);
            }
            catch (LocalBaseException ex) {
                throw new IOException(COULD_NOT_UPDATE_DOCUMENT, (Throwable)((Object)ex));
            }
        } else {
            this.getParent().createResource(this.getName(), content, this.binary, this.contentType);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocalResource)) {
            return false;
        }
        LocalResource other = (LocalResource)obj;
        return this.getPath().equals(other.getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    protected LocalFile getDocument() throws IOException {
        LocalObject object = this.getLocalObject();
        if (object == null) {
            return null;
        }
        if (!(object instanceof LocalFile)) {
            return null;
        }
        return (LocalFile)object;
    }

    protected LocalFile getDocumentSafe() throws IOException {
        LocalFile document = this.getDocument();
        if (document == null) {
            throw new IOException(MessageFormat.format(THERE_IS_NO_RESOURCE_AT_PATH_0, this.getPath()));
        }
        return document;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContent(byte[] content, boolean isBinary, String contentType) throws IOException {
        this.binary = isBinary;
        this.contentType = contentType;
        if (!isBinary) {
            this.setContent(content);
        }
        if (this.exists()) {
            LocalFile document = this.getDocumentSafe();
            try {
                document.setData(content);
            }
            catch (LocalBaseException ex) {
                throw new IOException(COULD_NOT_UPDATE_DOCUMENT, (Throwable)((Object)ex));
            }
        } else {
            this.getParent().createResource(this.getName(), content, this.binary, contentType);
        }
    }

    public List<IResourceVersion> getResourceVersions() throws IOException {
        try {
            return this.getRepository().getRepositoryDAO().getResourceVersionsByPath(this.getPath());
        }
        catch (LocalBaseException ex) {
            logger.error(ex.getMessage(), (Throwable)((Object)ex));
            return null;
        }
    }

    public IResourceVersion getResourceVersion(int version) throws IOException {
        return null;
    }
}

