/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizard.file;

import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.shared.IContentProvider;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.shared.TextContentProvider;
import org.eclipse.dirigible.ide.workspace.ui.shared.ValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewerUtils;
import org.eclipse.dirigible.ide.workspace.ui.wizard.file.Messages;
import org.eclipse.dirigible.repository.logging.Logger;

public class NewFileWizardModel {
    private static final String COULD_NOT_READ_FILE_CONTENT = Messages.NewFileWizardModel_COULD_NOT_READ_FILE_CONTENT;
    private static final String A_RESOURCE_WITH_THAT_PATH_ALREADY_EXISTS = Messages.NewFileWizardModel_A_RESOURCE_WITH_THAT_PATH_ALREADY_EXISTS;
    private static final String INVALID_FILE_NAME = Messages.NewFileWizardModel_INVALID_FILE_NAME;
    private static final String INVALID_PARENT_PATH = Messages.NewFileWizardModel_INVALID_PARENT_PATH;
    private static final String CONTENT_PROVIDER_CANNOT_BE_NULL = Messages.NewFileWizardModel_CONTENT_PROVIDER_CANNOT_BE_NULL;
    private static final String PARENT_LOCATION_CANNOT_BE_NULL = Messages.NewFileWizardModel_PARENT_LOCATION_CANNOT_BE_NULL;
    private static final String FILE_NAME_CANNOT_BE_NULL = Messages.NewFileWizardModel_FILE_NAME_CANNOT_BE_NULL;
    private String fileName = "file.txt";
    private String parentLocation = "";
    private IContentProvider contentProvider = new TextContentProvider();
    private static final Logger logger = Logger.getLogger(NewFileWizardModel.class);

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(FILE_NAME_CANNOT_BE_NULL);
        }
        this.fileName = name;
    }

    public String getParentLocation() {
        return this.parentLocation;
    }

    public void setParentLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException(PARENT_LOCATION_CANNOT_BE_NULL);
        }
        this.parentLocation = location;
    }

    public IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (contentProvider == null) {
            throw new IllegalArgumentException(CONTENT_PROVIDER_CANNOT_BE_NULL);
        }
        this.contentProvider = contentProvider;
    }

    public IValidationStatus validate() {
        IValidationStatus locationValidation = this.validateResourceLocation();
        IValidationStatus contentValidation = this.validateResourceContent();
        if (locationValidation.hasErrors()) {
            return locationValidation;
        }
        if (contentValidation.hasErrors()) {
            return contentValidation;
        }
        String warningMessage = "";
        if (locationValidation.hasWarnings()) {
            warningMessage = String.valueOf(warningMessage) + locationValidation.getMessage() + "\n\n";
        }
        if (contentValidation.hasWarnings()) {
            warningMessage = String.valueOf(warningMessage) + contentValidation.getMessage() + "\n";
        }
        if (!warningMessage.isEmpty()) {
            return ValidationStatus.createWarning(warningMessage);
        }
        return ValidationStatus.createOk();
    }

    private IValidationStatus validateResourceLocation() {
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IStatus folderLocationValidation = workspace.validatePath(this.parentLocation, 2);
        IStatus projectLocationValidation = workspace.validatePath(this.parentLocation, 4);
        if (!folderLocationValidation.isOK() && !projectLocationValidation.isOK()) {
            return ValidationStatus.createError(INVALID_PARENT_PATH);
        }
        if (this.parentLocation.contains("ScriptingServices") || this.parentLocation.contains("DataStructures")) {
            if (this.isValidScriptingServiceFileName(this.fileName)) {
                IWorkspaceRoot root = workspace.getRoot();
                if (this.isResourceExist(root)) {
                    return ValidationStatus.createError(A_RESOURCE_WITH_THAT_PATH_ALREADY_EXISTS);
                }
                return ValidationStatus.createOk();
            }
            return ValidationStatus.createError(INVALID_FILE_NAME);
        }
        IStatus nameValidation = workspace.validateName(this.fileName, 1);
        if (!nameValidation.isOK()) {
            return ValidationStatus.createError(INVALID_FILE_NAME);
        }
        IWorkspaceRoot root = workspace.getRoot();
        if (this.isResourceExist(root)) {
            return ValidationStatus.createError(A_RESOURCE_WITH_THAT_PATH_ALREADY_EXISTS);
        }
        return ValidationStatus.createOk();
    }

    private IValidationStatus validateResourceContent() {
        return this.contentProvider.validate();
    }

    public void execute() throws CoreException {
        IPath location = new Path(this.parentLocation).append(this.fileName);
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile(location);
        try {
            file.create(this.contentProvider.getContent(), false, null);
            IContainer parent = file.getParent();
            if (parent != null) {
                WorkspaceViewerUtils.expandElement(parent);
            }
            WorkspaceViewerUtils.selectElement(file);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CoreException((IStatus)new Status(4, "plugin", COULD_NOT_READ_FILE_CONTENT));
        }
    }

    private boolean isValidScriptingServiceFileName(String fileName) {
        String scriptingServicefileRegExPattern = "([a-zA-Z_0-9]+)+([\\.]){0,1}(([a-zA-Z0-9]*)*)";
        return Pattern.matches(scriptingServicefileRegExPattern, fileName);
    }

    private boolean isResourceExist(IWorkspaceRoot root) {
        IPath location = new Path(this.parentLocation).append(this.fileName);
        IResource resource = root.findMember(location.toString());
        return resource != null;
    }
}

