/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dirigible.ide.template.ui.db.wizard.AddColumnDialog;
import org.eclipse.dirigible.ide.template.ui.db.wizard.ColumnDefinition;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateStructurePageLabelProvider;
import org.eclipse.dirigible.ide.template.ui.db.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.db.wizard.TableTemplateModel;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.shared.FocusableWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DataStructureTemplateStructurePage
extends FocusableWizardPage {
    private static final long serialVersionUID = -1988896787139142411L;
    private static final String REMOVE = Messages.DataStructureTemplateStructurePage_REMOVE;
    private static final String ADD = Messages.DataStructureTemplateStructurePage_ADD;
    private static final String TREE_DEFAULT = Messages.DataStructureTemplateStructurePage_TREE_DEFAULT;
    private static final String TREE_PK = Messages.DataStructureTemplateStructurePage_TREE_PK;
    private static final String TREE_NN = Messages.DataStructureTemplateStructurePage_TREE_NN;
    private static final String TREE_LENGTH = Messages.DataStructureTemplateStructurePage_TREE_LENGTH;
    private static final String TREE_TYPE = Messages.DataStructureTemplateStructurePage_TREE_TYPE;
    private static final String TREE_NAME = Messages.DataStructureTemplateStructurePage_TREE_NAME;
    private static final String COLUMN_DEFINITIONS = Messages.DataStructureTemplateStructurePage_COLUMN_DEFINITIONS;
    private static final String ADD_COLUMN_DEFINITIONS_FOR_THE_SELECTED_DATA_STRUCTURE = Messages.DataStructureTemplateStructurePage_ADD_COLUMN_DEFINITIONS_FOR_THE_SELECTED_DATA_STRUCTURE;
    private static final String DEFINITION_OF_COLUMNS = Messages.DataStructureTemplateStructurePage_DEFINITION_OF_COLUMNS;
    private static final String REMOVE_COLUMN = Messages.DataStructureTemplateStructurePage_REMOVE_COLUMN;
    private static final String ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THE_SELECTED_COLUMN = Messages.DataStructureTemplateStructurePage_ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THE_SELECTED_COLUMN;
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateStructurePage";
    private TableTemplateModel model;
    private TreeViewer typeViewer;
    private Button addButton;
    private Button removeButton;
    private ColumnDefinition[] columnDefinitions;

    protected DataStructureTemplateStructurePage(TableTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(DEFINITION_OF_COLUMNS);
        this.setDescription(ADD_COLUMN_DEFINITIONS_FOR_THE_SELECTED_DATA_STRUCTURE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createColumnsField(composite);
        Composite compositeButtons = new Composite(composite, 0);
        compositeButtons.setLayout((Layout)new RowLayout());
        this.createButtonsField(compositeButtons);
        this.checkPageStatus();
        this.hideErrorMessages();
    }

    private void createColumnsField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(COLUMN_DEFINITIONS);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.typeViewer = new TreeViewer(parent, 68354);
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.setContentProvider((IContentProvider)new DataStructureTemplateStructurePageViewContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new DataStructureTemplateStructurePageLabelProvider());
        Tree tree = this.typeViewer.getTree();
        tree.setHeaderVisible(true);
        this.createTreeHeader(tree);
        this.columnDefinitions = this.createColumnDefinitions();
        this.typeViewer.setInput((Object)this.columnDefinitions);
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataStructureTemplateStructurePage.this.updateColumnDefinitions();
                DataStructureTemplateStructurePage.this.checkPageStatus();
            }
        });
        this.updateColumnDefinitions();
        this.checkPageStatus();
    }

    private void createTreeHeader(Tree tree) {
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(TREE_NAME);
        column.setWidth(150);
        column = new TreeColumn(tree, 16384);
        column.setText(TREE_TYPE);
        column.setWidth(100);
        column = new TreeColumn(tree, 131072);
        column.setText(TREE_LENGTH);
        column.setWidth(70);
        column = new TreeColumn(tree, 0x1000000);
        column.setText(TREE_NN);
        column.setWidth(50);
        column = new TreeColumn(tree, 0x1000000);
        column.setText(TREE_PK);
        column.setWidth(50);
        column = new TreeColumn(tree, 16384);
        column.setText(TREE_DEFAULT);
        column.setWidth(100);
    }

    private void createButtonsField(Composite parent) {
        this.addButton = new Button(parent, 2048);
        this.addButton.setText(ADD);
        this.addButton.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 7621468345508014093L;

            public void widgetSelected(SelectionEvent e) {
                DataStructureTemplateStructurePage.this.addClickedEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DataStructureTemplateStructurePage.this.addClickedEvent();
            }
        });
        this.setFocusable((Control)this.addButton);
        this.removeButton = new Button(parent, 2048);
        this.removeButton.setText(REMOVE);
        this.removeButton.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = -301365843089640919L;

            public void widgetSelected(SelectionEvent e) {
                DataStructureTemplateStructurePage.this.removeClicked();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DataStructureTemplateStructurePage.this.removeClicked();
            }
        });
    }

    private void addClickedEvent() {
        this.setEnabled(false);
        this.addClicked();
        this.setEnabled(true);
    }

    private void addClicked() {
        ColumnDefinition columnDefinition = new ColumnDefinition();
        AddColumnDialog addColumnDialog = new AddColumnDialog(columnDefinition, (ColumnDefinition[])this.columnDefinitions.clone(), this.getShell());
        int result = addColumnDialog.open();
        if (result == 0) {
            this.columnDefinitions = (ColumnDefinition[])this.typeViewer.getInput();
            this.columnDefinitions = Arrays.copyOf(this.columnDefinitions, this.columnDefinitions.length + 1);
            this.columnDefinitions[this.columnDefinitions.length - 1] = columnDefinition;
            this.typeViewer.setInput((Object)this.columnDefinitions);
            this.updateColumnDefinitions();
            this.checkPageStatus();
        }
    }

    private void removeClicked() {
        TreeItem[] selection = this.typeViewer.getTree().getSelection();
        ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
        if (selection != null && selection.length > 0 && MessageDialog.openQuestion(null, (String)REMOVE_COLUMN, (String)ARE_YOU_SURE_YOU_WANT_TO_REMOVE_THE_SELECTED_COLUMN)) {
            TreeItem[] treeItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem nextSelection = treeItemArray[n2];
                removeIndexes.add(this.typeViewer.getTree().indexOf(nextSelection));
                ++n2;
            }
            this.columnDefinitions = (ColumnDefinition[])this.typeViewer.getInput();
            this.columnDefinitions = this.removeColumnsFromTable(this.columnDefinitions, removeIndexes);
            this.typeViewer.setInput((Object)this.columnDefinitions);
            this.updateColumnDefinitions();
            this.checkPageStatus();
        }
    }

    private ColumnDefinition[] removeColumnsFromTable(ColumnDefinition[] columns, List<Integer> removeIndexes) {
        HashMap<Integer, ColumnDefinition> columnDefinitions = new HashMap<Integer, ColumnDefinition>();
        int i = 0;
        while (i < columns.length) {
            columnDefinitions.put(i, columns[i]);
            ++i;
        }
        for (Integer removeIndex : removeIndexes) {
            columnDefinitions.remove(removeIndex);
        }
        Collection values = columnDefinitions.values();
        return values.toArray(new ColumnDefinition[values.size()]);
    }

    private void updateColumnDefinitions() {
        ColumnDefinition[] columnDefinitions = (ColumnDefinition[])this.typeViewer.getInput();
        this.model.setColumnDefinitions(columnDefinitions);
    }

    private ColumnDefinition[] createColumnDefinitions() {
        ArrayList columnDefinitions = new ArrayList();
        return columnDefinitions.toArray(new ColumnDefinition[0]);
    }

    private void checkPageStatus() {
        IValidationStatus status = this.model.validateColumnDefinitions();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private void hideErrorMessages() {
        this.setErrorMessage(null);
    }

    class DataStructureTemplateStructurePageViewContentProvider
    implements ITreeContentProvider {
        private static final long serialVersionUID = 9053893213315991958L;

        DataStructureTemplateStructurePageViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

