/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.editor;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.db.viewer.editor.DbEditorInput;
import org.eclipse.dirigible.ide.db.viewer.editor.Messages;
import org.eclipse.dirigible.repository.datasource.DataSources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class TableDetailsEditorPage
extends EditorPart {
    private static final String LENGTH_TEXT = Messages.TableDetailsEditorPage_LENGTH_TEXT;
    private static final String KEY_TEXT = Messages.TableDetailsEditorPage_KEY_TEXT;
    private static final String ALLOW_NULL_TEXT = Messages.TableDetailsEditorPage_ALLOW_NULL_TEXT;
    private static final String PAGES_TEXT = Messages.TableDetailsEditorPage_PAGES_TEXT;
    private static final String CARDINALITY_TEXT = Messages.TableDetailsEditorPage_CARDINALITY_TEXT;
    private static final String ASC_DESC_TEXT = Messages.TableDetailsEditorPage_ASC_DESC_TEXT;
    private static final String ORDINAL_POSITION_TEXT = Messages.TableDetailsEditorPage_ORDINAL_POSITION_TEXT;
    private static final String QUALIFIER_TEXT = Messages.TableDetailsEditorPage_QUALIFIER_TEXT;
    private static final String NON_UNIQUE_TEXT = Messages.TableDetailsEditorPage_NON_UNIQUE_TEXT;
    private static final String COLUMN_NAME_TEXT = Messages.TableDetailsEditorPage_COLUMN_NAME_TEXT;
    private static final String TYPE_TEXT = Messages.TableDetailsEditorPage_TYPE_TEXT;
    private static final String INDEX_NAME_TEXT = Messages.TableDetailsEditorPage_INDEX_NAME_TEXT;
    private static final String INDEXES_TEXT = Messages.TableDetailsEditorPage_INDEXES_TEXT;
    private static final String FILTER_CONDITION_TEXT = Messages.TableDetailsEditorPage_FILTER_CONDITION_TEXT;
    protected boolean dirty = false;
    private Tree defTreeTable;
    private Tree indexesTable;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    protected void setDirty(boolean value) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 2560);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDefinitionTable((Composite)sashForm);
        this.createIndexesTable((Composite)sashForm);
        sashForm.setWeights(new int[]{70, 30});
        try {
            this.initData();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createIndexesTable(Composite mainComposite) {
        Composite indexComposite = new Composite(mainComposite, 0);
        GridLayout flat = new GridLayout();
        flat.horizontalSpacing = 0;
        flat.marginWidth = 0;
        indexComposite.setLayout((Layout)flat);
        GridData gridDataTable = new GridData();
        gridDataTable.horizontalAlignment = 4;
        gridDataTable.verticalAlignment = 4;
        gridDataTable.grabExcessHorizontalSpace = true;
        gridDataTable.grabExcessVerticalSpace = true;
        gridDataTable.horizontalIndent = 0;
        Label l = new Label(indexComposite, 16384);
        l.setText(INDEXES_TEXT);
        this.indexesTable = new Tree(indexComposite, 2816);
        this.indexesTable.setLayoutData((Object)gridDataTable);
        this.indexesTable.setHeaderVisible(true);
        TreeColumn iName = new TreeColumn(this.indexesTable, 16384);
        iName.setText(INDEX_NAME_TEXT);
        iName.setWidth(220);
        TreeColumn iType = new TreeColumn(this.indexesTable, 0x1000000);
        iType.setText(TYPE_TEXT);
        iType.setWidth(50);
        TreeColumn cname = new TreeColumn(this.indexesTable, 131072);
        cname.setText(COLUMN_NAME_TEXT);
        cname.setWidth(150);
        TreeColumn nonUnique = new TreeColumn(this.indexesTable, 131072);
        nonUnique.setText(NON_UNIQUE_TEXT);
        nonUnique.setWidth(90);
        TreeColumn indexQualifier = new TreeColumn(this.indexesTable, 131072);
        indexQualifier.setText(QUALIFIER_TEXT);
        indexQualifier.setWidth(80);
        TreeColumn ordinalPosition = new TreeColumn(this.indexesTable, 131072);
        ordinalPosition.setText(ORDINAL_POSITION_TEXT);
        ordinalPosition.setWidth(120);
        TreeColumn ascVsDesc = new TreeColumn(this.indexesTable, 131072);
        ascVsDesc.setText(ASC_DESC_TEXT);
        ascVsDesc.setWidth(80);
        TreeColumn cardinality = new TreeColumn(this.indexesTable, 131072);
        cardinality.setText(CARDINALITY_TEXT);
        cardinality.setWidth(80);
        TreeColumn pages = new TreeColumn(this.indexesTable, 131072);
        pages.setText(PAGES_TEXT);
        pages.setWidth(50);
        TreeColumn filterCondition = new TreeColumn(this.indexesTable, 131072);
        filterCondition.setText(FILTER_CONDITION_TEXT);
        filterCondition.setWidth(120);
    }

    private void createDefinitionTable(Composite parent) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.defTreeTable = new Tree(parent, 2816);
        this.defTreeTable.setLayoutData((Object)gd);
        this.defTreeTable.setHeaderVisible(true);
        TreeColumn columnName = new TreeColumn(this.defTreeTable, 16384);
        columnName.setText(COLUMN_NAME_TEXT);
        columnName.setWidth(200);
        TreeColumn columnType = new TreeColumn(this.defTreeTable, 0x1000000);
        columnType.setText(TYPE_TEXT);
        columnType.setWidth(200);
        TreeColumn columnLength = new TreeColumn(this.defTreeTable, 131072);
        columnLength.setText(LENGTH_TEXT);
        columnLength.setWidth(80);
        TreeColumn allowNull = new TreeColumn(this.defTreeTable, 131072);
        allowNull.setText(ALLOW_NULL_TEXT);
        allowNull.setWidth(80);
        TreeColumn key = new TreeColumn(this.defTreeTable, 131072);
        key.setText(KEY_TEXT);
        key.setWidth(50);
    }

    private void initData() throws SQLException {
        DbEditorInput input = (DbEditorInput)this.getEditorInput();
        String tableName = input.getTableName();
        String catalogName = input.getTableDefinition().getCatalogName();
        String schemaName = input.getTableDefinition().getSchemaName();
        Connection connection = input.getDbConnectionFactory().getDatabaseConnection();
        try {
            DataSources.iterateTableDefinition((Connection)connection, (String)tableName, (String)catalogName, (String)schemaName, (DataSources.ColumnsIteratorCallback)new DataSources.ColumnsIteratorCallback(){

                public void onColumn(String columnName, String columnType, String columnSize, String isNullable, String isKey) {
                    TreeItem item = new TreeItem(TableDetailsEditorPage.this.defTreeTable, 0);
                    item.setText(new String[]{columnName, columnType, columnSize, isNullable, isKey});
                }
            }, (DataSources.IndicesIteratorCallback)new DataSources.IndicesIteratorCallback(){

                public void onIndex(String indexName, String indexType, String columnName, String isNonUnique, String indexQualifier, String ordinalPosition, String sortOrder, String cardinality, String pagesIndex, String filterCondition) {
                    TreeItem item = new TreeItem(TableDetailsEditorPage.this.indexesTable, 0);
                    item.setText(new String[]{indexName, indexType, columnName, isNonUnique, indexQualifier, ordinalPosition, sortOrder, cardinality, pagesIndex, filterCondition});
                }
            });
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void setFocus() {
        this.defTreeTable.setFocus();
    }
}

