/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DBSequenceUtils {
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String VALUES = " VALUES (?, ?)";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String SET_SEQ_VALUE = " SET SEQ_VALUE=? ";
    private static final String UPDATE = "UPDATE ";
    private static final String SEQ_VALUE = "SEQ_VALUE";
    private static final String WHERE_SEQ_NAME = " WHERE SEQ_NAME=?";
    private static final String SELECT_FROM = "SELECT * FROM ";
    private static final String SEQ_NAME_VARCHAR_128_SEQ_VALUE_INTEGER = " (SEQ_NAME VARCHAR(128) NOT NULL PRIMARY KEY, SEQ_VALUE INTEGER)";
    private static final String CREATE_TABLE = "CREATE TABLE ";
    private static final String DGB_SEQUENCES = "DGB_SEQUENCES";
    private static final String SELECT_COUNT_FROM = "SELECT COUNT(*) FROM ";
    private DataSource dataSource;

    public DBSequenceUtils(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getNext(String sequenceName) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try {
            this.checkSequenceTable(connection);
            int value = this.increaseSequence(connection, sequenceName);
            if (value == -1) {
                value = this.increaseSequence(connection, sequenceName);
            }
            int n = value;
            return n;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public int createSequence(String sequenceName, int start) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try {
            this.checkSequenceTable(connection);
            this.insertSequence(connection, sequenceName, start);
            return 0;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public int dropSequence(String sequenceName) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try {
            this.checkSequenceTable(connection);
            this.deleteSequence(connection, sequenceName);
            return 0;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public boolean existSequence(String sequenceName) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try {
            boolean exists;
            this.checkSequenceTable(connection);
            boolean bl = exists = this.selectSequence(connection, sequenceName);
            return bl;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void checkSequenceTable(Connection connection) throws SQLException {
        String sql = "SELECT COUNT(*) FROM DGB_SEQUENCES";
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.executeQuery();
            }
            catch (Exception exception) {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                sql = "CREATE TABLE DGB_SEQUENCES (SEQ_NAME VARCHAR(128) NOT NULL PRIMARY KEY, SEQ_VALUE INTEGER)";
                preparedStatement = connection.prepareStatement(sql);
                try {
                    preparedStatement.executeUpdate();
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private int increaseSequence(Connection connection, String sequenceName) throws SQLException {
        String sql = "SELECT * FROM DGB_SEQUENCES WHERE SEQ_NAME=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, sequenceName);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int value = resultSet.getInt(SEQ_VALUE);
                this.updateSequence(connection, sequenceName, ++value);
                int n = value;
                return n;
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        this.insertSequence(connection, sequenceName, 0);
        return -1;
    }

    private void updateSequence(Connection connection, String sequenceName, int value) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String sql = "UPDATE DGB_SEQUENCES SET SEQ_VALUE=?  WHERE SEQ_NAME=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setInt(1, value);
            preparedStatement.setString(2, sequenceName);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private void insertSequence(Connection connection, String sequenceName, int start) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String sql = "INSERT INTO DGB_SEQUENCES VALUES (?, ?)";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, sequenceName);
            preparedStatement.setInt(2, start);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private void deleteSequence(Connection connection, String sequenceName) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String sql = "DELETE FROM DGB_SEQUENCES WHERE SEQ_NAME=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, sequenceName);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private boolean selectSequence(Connection connection, String sequenceName) throws SQLException {
        String sql = "SELECT * FROM DGB_SEQUENCES WHERE SEQ_NAME=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, sequenceName);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return true;
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return false;
    }
}

