/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rap.rwt.internal.theme.QxBorder;
import org.eclipse.rap.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.QxColor;
import org.eclipse.rap.rwt.internal.theme.QxDimension;
import org.eclipse.rap.rwt.internal.theme.QxFont;
import org.eclipse.rap.rwt.internal.theme.QxImage;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rap.rwt.internal.theme.WidgetMatcher;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractThemeAdapter
implements IThemeAdapter {
    private final WidgetMatcher matcher = new WidgetMatcher();

    public AbstractThemeAdapter() {
        this.configureMatcher(this.matcher);
    }

    public static String getPrimaryElement(Widget widget) {
        Class<?> widgetClass = widget.getClass();
        ThemeableWidget thWidget = AbstractThemeAdapter.findThemeableWidget(widget);
        if (thWidget == null || thWidget.elements == null) {
            throw new RuntimeException("No themeable widget found for " + widgetClass.getName());
        }
        return thWidget.elements[0].getName();
    }

    protected abstract void configureMatcher(WidgetMatcher var1);

    protected Color getCssColor(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return QxColor.createColor((QxColor)cssValue);
    }

    protected Font getCssFont(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return QxFont.createFont((QxFont)cssValue);
    }

    protected int getCssBorderWidth(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return ((QxBorder)cssValue).width;
    }

    protected int getCssDimension(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return ((QxDimension)cssValue).value;
    }

    protected Rectangle getCssBoxDimensions(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return QxBoxDimensions.createRectangle((QxBoxDimensions)cssValue);
    }

    protected Point getCssImageDimension(String cssElement, String cssProperty, Widget widget) {
        QxImage image = (QxImage)ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return new Point(image.width, image.height);
    }

    private static ThemeableWidget findThemeableWidget(Widget widget) {
        Class<?> widgetClass = widget.getClass();
        ThemeManager manager = ContextProvider.getApplicationContext().getThemeManager();
        ThemeableWidget result = manager.getThemeableWidget(widgetClass);
        while ((result == null || result.elements == null) && widgetClass.getSuperclass() != null) {
            widgetClass = widgetClass.getSuperclass();
            result = manager.getThemeableWidget(widgetClass);
        }
        return result;
    }
}

