/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IEntityInformation;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBCollection;
import org.eclipse.dirigible.repository.db.DBEntityInformation;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.Messages;
import org.eclipse.dirigible.repository.db.dao.DBObject;
import org.eclipse.dirigible.repository.logging.Logger;

public abstract class DBEntity
implements IEntity {
    private static final String THERE_IS_NO_ENTITY_AT_PATH_0 = Messages.getString("DBEntity.THERE_IS_NO_ENTITY_AT_PATH_0");
    private static final Logger logger = Logger.getLogger(DBEntity.class);
    private final DBRepository repository;
    private final RepositoryPath path;

    public DBEntity(DBRepository repository, RepositoryPath path) {
        this.repository = repository;
        this.path = path;
    }

    public DBRepository getRepository() {
        return this.repository;
    }

    protected RepositoryPath getRepositoryPath() {
        return this.path;
    }

    public String getName() {
        return this.path.getLastSegment();
    }

    public String getPath() {
        return this.path.toString();
    }

    public ICollection getParent() {
        RepositoryPath parentPath = this.path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        return new DBCollection(this.repository, parentPath);
    }

    public IEntityInformation getInformation() throws IOException {
        return new DBEntityInformation(this.path, this.getDBObjectSafe());
    }

    protected DBObject getDBObject() throws IOException {
        try {
            return this.repository.getRepositoryDAO().getObjectByPath(this.getPath());
        }
        catch (DBBaseException ex) {
            logger.error(ex.getMessage(), (Throwable)((Object)ex));
            return null;
        }
    }

    protected DBObject getDBObjectSafe() throws IOException {
        DBObject result = this.getDBObject();
        if (result == null) {
            throw new IOException(MessageFormat.format(THERE_IS_NO_ENTITY_AT_PATH_0, this.path.toString()));
        }
        return result;
    }

    protected void createAncestorsIfMissing() throws IOException {
        ICollection parent = this.getParent();
        if (parent != null && !parent.exists()) {
            parent.create();
        }
    }

    protected void createAncestorsAndSelfIfMissing() throws IOException {
        this.createAncestorsIfMissing();
        if (!this.exists()) {
            this.create();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBEntity)) {
            return false;
        }
        DBEntity other = (DBEntity)obj;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

