/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;

public class SequenceGenerator {
    public static final int DEFAULT_PREALLOCATION_COUNT = 5;
    private static final int PREALLOCATION_THRESHHOLD = 1;
    public static final int RET_I_AM_CONFUSED = 0;
    public static final int RET_OK = 1;
    public static final int RET_MARK_EXHAUSTED = 2;
    public static final int RET_ALLOCATE_NEW_VALUES = 3;
    public static final int CVAA_STATUS = 0;
    public static final int CVAA_CURRENT_VALUE = 1;
    public static final int CVAA_LAST_ALLOCATED_VALUE = 2;
    public static final int CVAA_NUMBER_OF_VALUES_ALLOCATED = 3;
    public static final int CVAA_LENGTH = 4;
    private final boolean _CAN_CYCLE;
    private final boolean _STEP_INCREASES;
    private final long _INCREMENT;
    private final long _MAX_VALUE;
    private final long _MIN_VALUE;
    private final long _RESTART_VALUE;
    private final String _SEQUENCE_NAME;
    private boolean _isExhausted;
    private long _currentValue;
    private long _valuesPerAllocation;
    private long _remainingPreallocatedValues;

    public SequenceGenerator(Long l, boolean bl, long l2, long l3, long l4, long l5, String string) {
        if (l == null) {
            this._isExhausted = true;
            this._currentValue = 0L;
        } else {
            this._isExhausted = false;
            this._currentValue = l;
        }
        this._CAN_CYCLE = bl;
        this._INCREMENT = l2;
        this._MAX_VALUE = l3;
        this._MIN_VALUE = l4;
        this._RESTART_VALUE = l5;
        this._STEP_INCREASES = this._INCREMENT > 0L;
        this._SEQUENCE_NAME = string;
        this._remainingPreallocatedValues = 1L;
        this._valuesPerAllocation = this.computePreAllocationCount();
    }

    public synchronized String getName() {
        return this._SEQUENCE_NAME;
    }

    public synchronized void allocateNewRange(long l, long l2) {
        if (this._currentValue == l) {
            this._remainingPreallocatedValues = l2;
        }
    }

    public synchronized Long peekAtCurrentValue() {
        Long l = null;
        if (!this._isExhausted) {
            l = new Long(this._currentValue);
        }
        return l;
    }

    public synchronized long[] getCurrentValueAndAdvance() throws StandardException {
        if (this._isExhausted) {
            throw StandardException.newException("2200H.S", this._SEQUENCE_NAME);
        }
        long[] lArray = new long[4];
        lArray[0] = 0L;
        lArray[1] = this._currentValue;
        this.advanceValue(lArray);
        return lArray;
    }

    private void advanceValue(long[] lArray) throws StandardException {
        long l = this._currentValue + this._INCREMENT;
        if (this.overflowed(this._currentValue, l)) {
            if (!this._CAN_CYCLE) {
                this.markExhausted(lArray);
                return;
            }
            l = this._RESTART_VALUE;
        }
        --this._remainingPreallocatedValues;
        if (this._remainingPreallocatedValues < 1L) {
            this.computeNewAllocation(this._currentValue, lArray);
            return;
        }
        this._currentValue = l;
        lArray[0] = 1L;
    }

    private void markExhausted(long[] lArray) {
        this._isExhausted = true;
        lArray[0] = 2L;
    }

    private boolean overflowed(long l, long l2) {
        boolean bl;
        boolean bl2 = bl = this._STEP_INCREASES == l2 < l;
        if (!bl) {
            bl = this._STEP_INCREASES ? l2 > this._MAX_VALUE : l2 < this._MIN_VALUE;
        }
        return bl;
    }

    private void computeNewAllocation(long l, long[] lArray) throws StandardException {
        long l2;
        long l3;
        long l4 = this.computeRemainingValues(l);
        if (l4 >= this._valuesPerAllocation) {
            l3 = l + this._valuesPerAllocation * this._INCREMENT;
            l2 = this._valuesPerAllocation;
        } else if (this._CAN_CYCLE) {
            long l5 = this._valuesPerAllocation - l4;
            l3 = this._RESTART_VALUE + --l5 * this._INCREMENT;
            l2 = this._valuesPerAllocation;
        } else {
            if (l4 <= 0L) {
                this.markExhausted(lArray);
                return;
            }
            l2 = l4;
            l3 = l + l2 * this._INCREMENT;
        }
        lArray[3] = l2 + 1L;
        lArray[2] = l3;
        lArray[0] = 3L;
    }

    private long computeRemainingValues(long l) {
        long l2;
        long l3 = l2 = this._STEP_INCREASES ? this._MAX_VALUE - l : -(this._MIN_VALUE - l);
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        long l4 = this._STEP_INCREASES ? this._INCREMENT : -this._INCREMENT;
        return l2 / l4;
    }

    private int computePreAllocationCount() {
        double d;
        int n = 5;
        int n2 = 1;
        double d2 = this._MIN_VALUE;
        double d3 = this._MAX_VALUE;
        double d4 = d3 - d2;
        double d5 = this._INCREMENT;
        if (d5 < 0.0) {
            d5 = -d5;
        }
        if ((d = d5 * (double)n) > 9.223372036854776E18) {
            return n2;
        }
        if (d > d4) {
            return n2;
        }
        return n;
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException("XSCB3.S");
    }
}

