/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.ocl;

import java.util.Collection;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IPatternConformityStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.SimpleStatus;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ITextualLanguageInterpreterFacade;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TextualRoleConstraint;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TextualRoleDerivationRule;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.Messages;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.OclPatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter.OclInterpreter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.ocl.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OclInterpreterFacade
implements ITextualLanguageInterpreterFacade {
    public IPatternConformityStatus checkElement(TextualRoleConstraint constraint_p, EObject element_p) {
        SimpleStatus result = SimpleStatus.SUCCESS;
        try {
            OclInterpreter interpreter = OclPatternsPlugin.getDefault().getInterpreter();
            boolean satisfied = interpreter.check(constraint_p.getSpecification(), element_p, constraint_p.getRole());
            if (satisfied) {
                result = new SimpleStatus(true, constraint_p.getSpecification());
            } else {
                String name = constraint_p.getRole().getName();
                String details = constraint_p.getRole().getDescription();
                if (details == null || details.length() == 0) {
                    details = constraint_p.getSpecification();
                }
                result = new SimpleStatus(false, String.format(Messages.OclInterpreterFacade_ConstraintViolation, name, details));
            }
        }
        catch (ParserException e) {
            result = new SimpleStatus(false, String.valueOf(Messages.OclFacade_ParsingError) + constraint_p.getSpecification());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public EList<EObject> deriveCandidateElements(TextualRoleDerivationRule rule_p, IPatternApplication context_p) {
        ModelsUtil.ROrderedSet result = null;
        try {
            OclInterpreter interpreter = OclPatternsPlugin.getDefault().getInterpreter();
            EObject context = context_p.getScopeElement() instanceof EObject ? (EObject)context_p.getScopeElement() : null;
            Object eval = interpreter.evaluate(rule_p.getSpecification(), context, rule_p.getRole(), context_p);
            if (eval != null) {
                result = new ModelsUtil.ROrderedSet();
                ModelsUtil.ROrderedSet evalCollection = new ModelsUtil.ROrderedSet();
                if (eval instanceof Collection) {
                    evalCollection.addAll((Collection)eval);
                } else {
                    evalCollection.add(eval);
                }
                for (Object obj : evalCollection) {
                    if (!(obj instanceof EObject) || obj instanceof DynamicEObjectImpl) continue;
                    result.add((Object)((EObject)obj));
                }
                result = ECollections.unmodifiableEList((EList)result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getLanguage() {
        return OclPatternsPlugin.getDefault().getLanguage();
    }
}

