/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.editors.text.EditorsUI;

public class LSPFormatter {
    public void applyEdits(IDocument document, List<? extends TextEdit> edits) {
        try {
            LSPEclipseUtils.applyEdits(document, edits);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public CompletableFuture<List<? extends TextEdit>> requestFormatting(@NonNull IDocument document, @NonNull ITextSelection textSelection) {
        List<@NonNull LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(document, LSPFormatter::supportFormatting);
        if (infos.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
        try {
            return this.requestFormatting(info, textSelection);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    private CompletableFuture<List<? extends TextEdit>> requestFormatting(LanguageServiceAccessor.LSPDocumentInfo info, ITextSelection textSelection) throws BadLocationException {
        TextDocumentIdentifier docId = new TextDocumentIdentifier(info.getFileUri().toString());
        ServerCapabilities capabilities = info.getCapabilites();
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        int tabWidth = store.getInt("tabWidth");
        boolean insertSpaces = store.getBoolean("spacesForTabs");
        if (capabilities != null && LSPFormatter.isDocumentRangeFormattingSupported(capabilities) && (!LSPFormatter.isDocumentFormattingSupported(capabilities) || textSelection.getLength() != 0)) {
            DocumentRangeFormattingParams params = new DocumentRangeFormattingParams();
            params.setTextDocument(docId);
            params.setOptions(new FormattingOptions(tabWidth, insertSpaces));
            boolean fullFormat = textSelection.getLength() == 0;
            Position start = LSPEclipseUtils.toPosition(fullFormat ? 0 : textSelection.getOffset(), info.getDocument());
            Position end = LSPEclipseUtils.toPosition(fullFormat ? info.getDocument().getLength() : textSelection.getOffset() + textSelection.getLength(), info.getDocument());
            params.setRange(new Range(start, end));
            return info.getInitializedLanguageClient().thenComposeAsync(server -> server.getTextDocumentService().rangeFormatting(params));
        }
        DocumentFormattingParams params = new DocumentFormattingParams();
        params.setTextDocument(docId);
        params.setOptions(new FormattingOptions(tabWidth, insertSpaces));
        return info.getInitializedLanguageClient().thenComposeAsync(server -> server.getTextDocumentService().formatting(params));
    }

    private static boolean isDocumentRangeFormattingSupported(ServerCapabilities capabilities) {
        return LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentRangeFormattingProvider());
    }

    private static boolean isDocumentFormattingSupported(ServerCapabilities capabilities) {
        return LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentFormattingProvider());
    }

    public static boolean supportFormatting(ServerCapabilities capabilities) {
        return LSPFormatter.isDocumentFormattingSupported(capabilities) || LSPFormatter.isDocumentRangeFormattingSupported(capabilities);
    }
}

