/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public abstract class RulerBreakpointAction
extends Action {
    private ITextEditor fEditor;
    private IVerticalRulerInfo fRulerInfo;

    public RulerBreakpointAction(ITextEditor editor, IVerticalRulerInfo info) {
        this.fEditor = editor;
        this.fRulerInfo = info;
    }

    protected IBreakpoint getBreakpoint() {
        IAnnotationModel annotationModel = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        IDocument document = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annot = (Annotation)iterator.next();
                if (!(annot instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)annot;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != this.fRulerInfo.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    protected ITextEditor getEditor() {
        return this.fEditor;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRulerInfo;
    }
}

