/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.tm4e.core.internal.utils.CompareUtils;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class ThemeTrieElement {
    private final ThemeTrieElementRule mainRule;
    private final List<ThemeTrieElementRule> rulesWithParentScopes;
    private final Map<String, ThemeTrieElement> children;

    public ThemeTrieElement(ThemeTrieElementRule mainRule) {
        this(mainRule, new ArrayList<ThemeTrieElementRule>(), new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes) {
        this(mainRule, rulesWithParentScopes, new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes, Map<String, ThemeTrieElement> children) {
        this.mainRule = mainRule;
        this.rulesWithParentScopes = rulesWithParentScopes;
        this.children = children;
    }

    private static List<ThemeTrieElementRule> sortBySpecificity(List<ThemeTrieElementRule> arr) {
        if (arr.size() == 1) {
            return arr;
        }
        arr.sort(ThemeTrieElement::cmpBySpecificity);
        return arr;
    }

    private static int cmpBySpecificity(ThemeTrieElementRule a, ThemeTrieElementRule b) {
        if (a.scopeDepth == b.scopeDepth) {
            int bParentScopesLen;
            List<String> aParentScopes = a.parentScopes;
            List<String> bParentScopes = b.parentScopes;
            int aParentScopesLen = aParentScopes == null ? 0 : aParentScopes.size();
            int n = bParentScopesLen = bParentScopes == null ? 0 : bParentScopes.size();
            if (aParentScopesLen == bParentScopesLen) {
                int i = 0;
                while (i < aParentScopesLen) {
                    int bLen;
                    int aLen = aParentScopes.get(i).length();
                    if (aLen != (bLen = bParentScopes.get(i).length())) {
                        return bLen - aLen;
                    }
                    ++i;
                }
            }
            return bParentScopesLen - aParentScopesLen;
        }
        return b.scopeDepth - a.scopeDepth;
    }

    public List<ThemeTrieElementRule> match(String scope) {
        String tail;
        String head;
        if ("".equals(scope)) {
            ArrayList<ThemeTrieElementRule> arr = new ArrayList<ThemeTrieElementRule>();
            arr.add(this.mainRule);
            arr.addAll(this.rulesWithParentScopes);
            return ThemeTrieElement.sortBySpecificity(arr);
        }
        int dotIndex = scope.indexOf(46);
        if (dotIndex == -1) {
            head = scope;
            tail = "";
        } else {
            head = scope.substring(0, dotIndex);
            tail = scope.substring(dotIndex + 1);
        }
        if (this.children.containsKey(head)) {
            return this.children.get(head).match(tail);
        }
        ArrayList<ThemeTrieElementRule> arr = new ArrayList<ThemeTrieElementRule>();
        arr.add(this.mainRule);
        arr.addAll(this.rulesWithParentScopes);
        return ThemeTrieElement.sortBySpecificity(arr);
    }

    public void insert(int scopeDepth, String scope, List<String> parentScopes, int fontStyle, int foreground, int background) {
        ThemeTrieElement child;
        String tail;
        String head;
        if ("".equals(scope)) {
            this.doInsertHere(scopeDepth, parentScopes, fontStyle, foreground, background);
            return;
        }
        int dotIndex = scope.indexOf(46);
        if (dotIndex == -1) {
            head = scope;
            tail = "";
        } else {
            head = scope.substring(0, dotIndex);
            tail = scope.substring(dotIndex + 1);
        }
        if (this.children.containsKey(head)) {
            child = this.children.get(head);
        } else {
            child = new ThemeTrieElement(this.mainRule.clone(), ThemeTrieElementRule.cloneArr(this.rulesWithParentScopes));
            this.children.put(head, child);
        }
        child.insert(scopeDepth + 1, tail, parentScopes, fontStyle, foreground, background);
    }

    private void doInsertHere(int scopeDepth, List<String> parentScopes, int fontStyle, int foreground, int background) {
        if (parentScopes == null) {
            this.mainRule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
            return;
        }
        for (ThemeTrieElementRule rule : this.rulesWithParentScopes) {
            if (CompareUtils.strArrCmp(rule.parentScopes, parentScopes) != 0) continue;
            rule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
            return;
        }
        if (fontStyle == -1) {
            fontStyle = this.mainRule.fontStyle;
        }
        if (foreground == 0) {
            foreground = this.mainRule.foreground;
        }
        if (background == 0) {
            background = this.mainRule.background;
        }
        this.rulesWithParentScopes.add(new ThemeTrieElementRule(scopeDepth, parentScopes, fontStyle, foreground, background));
    }

    public int hashCode() {
        return Objects.hash(this.children, this.mainRule, this.rulesWithParentScopes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThemeTrieElement other = (ThemeTrieElement)obj;
        return Objects.equals(this.children, other.children) && Objects.equals(this.mainRule, other.mainRule) && Objects.equals(this.rulesWithParentScopes, other.rulesWithParentScopes);
    }
}

