/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.participant;

import com.google.inject.Inject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationContext;
import org.eclipse.xtext.ui.refactoring2.participant.ResourceRelocationProcessor;

public class XtextRenameResourceParticipant
extends RenameParticipant
implements ISharableParticipant {
    @Inject
    private ResourceRelocationProcessor processor;
    private Change change;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        try {
            this.change = this.processor.createChange(this.getName(), ResourceRelocationContext.ChangeType.RENAME, pm);
            return this.processor.getIssues().getRefactoringStatus();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (CoreException e) {
            return RefactoringStatus.create((IStatus)e.getStatus());
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    public String getName() {
        return "Xtext rename resource participant";
    }

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        if (arguments instanceof RenameArguments && element instanceof IResource) {
            IPath oldPath = ((IResource)element).getFullPath();
            IPath newPath = oldPath.removeLastSegments(1).append(((RenameArguments)arguments).getNewName());
            this.processor.addChangedResource((IResource)element, oldPath, newPath);
        }
    }
}

