/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutData;
import org.osgi.framework.Bundle;

public class AboutBundleData
extends AboutData {
    private Bundle bundle;
    private boolean isSignedDetermined = false;
    private boolean isSigned;

    public AboutBundleData(Bundle bundle) {
        super(AboutBundleData.getResourceString(bundle, "Bundle-Vendor"), AboutBundleData.getResourceString(bundle, "Bundle-Name"), AboutBundleData.getResourceString(bundle, "Bundle-Version"), bundle.getSymbolicName());
        this.bundle = bundle;
    }

    public int getState() {
        return this.bundle.getState();
    }

    public String getStateName() {
        switch (this.getState()) {
            case 2: {
                return WorkbenchMessages.AboutPluginsDialog_state_installed;
            }
            case 4: {
                return WorkbenchMessages.AboutPluginsDialog_state_resolved;
            }
            case 8: {
                return WorkbenchMessages.AboutPluginsDialog_state_starting;
            }
            case 16: {
                return WorkbenchMessages.AboutPluginsDialog_state_stopping;
            }
            case 1: {
                return WorkbenchMessages.AboutPluginsDialog_state_uninstalled;
            }
            case 32: {
                return WorkbenchMessages.AboutPluginsDialog_state_active;
            }
        }
        return WorkbenchMessages.AboutPluginsDialog_state_unknown;
    }

    private static String getResourceString(Bundle bundle, String headerName) {
        String value = (String)bundle.getHeaders().get(headerName);
        return value == null ? null : Platform.getResourceString((Bundle)bundle, (String)value);
    }

    public boolean isSignedDetermined() {
        return this.isSignedDetermined;
    }

    public boolean isSigned() throws IllegalStateException {
        if (this.isSignedDetermined) {
            return this.isSigned;
        }
        SignedContent signedContent = this.getSignedContent();
        this.isSigned = signedContent != null && signedContent.isSigned();
        this.isSignedDetermined = true;
        return this.isSigned;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public SignedContent getSignedContent() throws IllegalStateException {
        SignedContent[] result = new SignedContent[1];
        ServiceCaller.callOnce(this.getClass(), SignedContentFactory.class, contentFactory -> {
            try {
                signedContentArray[0] = contentFactory.getSignedContent(this.bundle);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        });
        return result[0];
    }
}

