/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.ISessionListener;
import org.eclipse.pde.api.tools.internal.provisional.ISessionManager;

public class SessionManager
implements ISessionManager {
    private List<ISession> sessions = new ArrayList<ISession>();
    private Set<ISessionListener> listeners = new HashSet<ISessionListener>();
    private ISession activeSession;

    @Override
    public synchronized void addSession(ISession session, boolean activate) {
        if (session == null) {
            throw new IllegalArgumentException("The given session cannot be null");
        }
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
            this.fireSessionAdded(session);
        }
        if (activate) {
            this.activeSession = session;
            this.fireSessionActivated(session);
        }
    }

    @Override
    public synchronized void removeSession(ISession session) {
        if (this.sessions.remove(session)) {
            if (session.equals(this.activeSession)) {
                this.activeSession = null;
                this.fireSessionActivated(null);
            }
            this.fireSessionRemoved(session);
        }
    }

    @Override
    public synchronized void removeAllSessions() {
        ISession[] allSessions = this.sessions.toArray(new ISession[this.sessions.size()]);
        this.sessions.clear();
        this.activeSession = null;
        this.fireSessionActivated(null);
        ISession[] iSessionArray = allSessions;
        int n = allSessions.length;
        int n2 = 0;
        while (n2 < n) {
            ISession session = iSessionArray[n2];
            this.fireSessionRemoved(session);
            ++n2;
        }
    }

    @Override
    public synchronized ISession[] getSessions() {
        return this.sessions.toArray(new ISession[this.sessions.size()]);
    }

    @Override
    public synchronized void addSessionListener(ISessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The given listener cannot be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeSessionListener(ISessionListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireSessionAdded(ISession session) {
        for (ISessionListener listener : this.listeners) {
            listener.sessionAdded(session);
        }
    }

    protected synchronized void fireSessionRemoved(ISession session) {
        for (ISessionListener listener : this.listeners) {
            listener.sessionRemoved(session);
        }
    }

    @Override
    public ISession getActiveSession() {
        return this.activeSession;
    }

    protected synchronized void fireSessionActivated(ISession session) {
        for (ISessionListener listener : this.listeners) {
            listener.sessionActivated(session);
        }
    }

    @Override
    public void activateSession(ISession session) {
        if (this.sessions.contains(session) && !session.equals(this.activeSession)) {
            this.activeSession = session;
            this.fireSessionActivated(session);
        }
    }
}

