/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.heapwalking;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.heapwalking.AllInstancesActionDelegate;
import org.eclipse.jdt.internal.debug.ui.heapwalking.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class InstanceCountActionDelegate
extends AllInstancesActionDelegate {
    @Override
    protected void displayInstaces(IJavaDebugTarget target, JDIReferenceType rtype) {
        try {
            this.displayNumInstances(rtype.getName(), rtype.getInstanceCount());
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            this.report(Messages.AllInstancesActionDelegate_0, this.getPart());
        }
    }

    @Override
    protected void displayNoInstances(IJavaDebugTarget target, String typeName) {
        this.displayNumInstances(typeName, 0L);
    }

    protected void displayNumInstances(String typeName, long instanceCount) {
        String message = null;
        message = instanceCount == 0L ? NLS.bind((String)Messages.InstanceCountActionDelegate_0, (Object[])new String[]{typeName}) : (instanceCount == 1L ? NLS.bind((String)Messages.InstanceCountActionDelegate_1, (Object[])new String[]{typeName}) : NLS.bind((String)Messages.InstanceCountActionDelegate_2, (Object[])new String[]{Long.toString(instanceCount), typeName}));
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.InstanceCountActionDelegate_3, (String)message);
    }
}

