/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.CommandReplyWithVars;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.Multiplicity;
import org.eclipse.comma.actions.actions.PCElement;
import org.eclipse.comma.actions.actions.PCFragmentReference;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.parameters.parameters.NotificationParams;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.ReplyParams;
import org.eclipse.comma.parameters.parameters.StateOtherParams;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.StateReplyParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.petrinet.Guard;
import org.eclipse.comma.petrinet.GuardContext;
import org.eclipse.comma.petrinet.Input;
import org.eclipse.comma.petrinet.Output;
import org.eclipse.comma.petrinet.PTransition;
import org.eclipse.comma.petrinet.PetrinetBuilder;
import org.eclipse.comma.petrinet.Place;
import org.eclipse.comma.petrinet.PythonHelper;
import org.eclipse.comma.petrinet.Token;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class Petrinet {
    private final Interface itf;
    private final String port;
    private final String component;
    private final ParameterPlaceMode mode;
    private final Parameters params;
    private final PetrinetBuilder.PortDirection portDirection;
    private Map<String, Place> places = new LinkedHashMap<String, Place>();
    private ArrayList<PTransition> transitions = new ArrayList();
    private ArrayList<Input> inputs = new ArrayList();
    private ArrayList<Output> outputs = new ArrayList();
    private List<String> globalVariables;

    Petrinet(Interface itf, Parameters params, ParameterPlaceMode mode, String port, String component, PetrinetBuilder.PortDirection portDirection) {
        this.itf = itf;
        this.params = params;
        this.mode = mode;
        this.port = port;
        this.component = component;
        this.portDirection = portDirection;
        this.build();
    }

    private Petrinet build() {
        PTransition.resetIDCounter();
        this.globalVariables = this.itf.getVars().stream().map(v -> v.getName()).collect(Collectors.toList());
        for (StateMachine machine : this.itf.getMachines()) {
            for (State state : machine.getStates()) {
                Place source = this.add(Place.forState(machine, state));
                Iterator<Token> transitions = new ArrayList(state.getTransitions());
                machine.getInAllStates().stream().filter(s -> !s.getExcludedStates().contains((Object)state)).forEach(s -> {
                    boolean bl = transitions.addAll((Collection<Token>)s.getTransitions());
                });
                Iterator<Object> iterator = transitions.iterator();
                while (iterator.hasNext()) {
                    Transition transition = (Transition)iterator.next();
                    RetVal retVal = RetVal.NONE;
                    if (!(transition instanceof TriggeredTransition) ? (retVal = this.needsTransitionToBeSkipped(source, (NonTriggeredTransition)transition)) == RetVal.SKIP : (retVal = this.needsTransitionToBeSkipped(source, (TriggeredTransition)transition)) == RetVal.SKIP) continue;
                    TriggeredTransition trigger = transition instanceof TriggeredTransition ? (TriggeredTransition)transition : null;
                    Place intermediate = this.add(Place.forTransition(machine, state, transition));
                    Guard guard = transition.getGuard() != null ? new Guard(transition.getGuard(), GuardContext.TRANSITION) : null;
                    this.add(new PTransition(transition, trigger, guard, null, this.component, retVal == RetVal.BREAK), source, intermediate, null);
                    for (Clause clause : transition.getClauses()) {
                        retVal = this.needsClauseToBeSkipped(source, clause);
                        if (retVal == RetVal.SKIP) continue;
                        Place clausePlace = this.add(Place.forClause(intermediate, clause));
                        this.add(new PTransition(transition, this.component, retVal == RetVal.BREAK), intermediate, clausePlace, null);
                        State targetState = clause.getTarget() == null ? state : clause.getTarget();
                        Place target = this.add(Place.forState(machine, targetState));
                        if (clause.getActions() == null) {
                            this.add(new PTransition(transition, this.component, retVal == RetVal.BREAK), clausePlace, target, null);
                            continue;
                        }
                        this.addClause(transition, (List<Action>)clause.getActions().getActions(), clausePlace, target, trigger, retVal == RetVal.BREAK);
                    }
                }
            }
        }
        this.places.values().stream().filter(p -> p.isInitial()).forEach(p -> p.addToken(Token.empty()));
        for (PTransition transition : this.transitions) {
            Place place;
            boolean addTokens;
            Place place2;
            if (transition.event == null) continue;
            Place source = this.getSource(transition);
            if (transition.event instanceof ActionWithVars && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY) {
                place2 = Place.forParameters(transition, source.state);
                if (!this.places.containsKey(place2.name)) {
                    this.add(place2);
                    if (transition.event instanceof EventWithVars) {
                        for (Token t : this.getTokens(source, (EventWithVars)transition.event)) {
                            place2.addToken(t);
                        }
                    } else {
                        for (Token t : this.getTokens(source, (CommandReplyWithVars)transition.event)) {
                            place2.addToken(t);
                        }
                    }
                }
                this.inputs.add(new Input(place2, transition));
                this.outputs.add(new Output(place2, transition, null));
            } else if (transition.event instanceof CommandReply && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY) {
                if (this.getTokens(source, (CommandReply)transition.event).size() > 0) {
                    place2 = Place.forParameters(transition, source.state);
                    if (!this.places.containsKey(place2.name)) {
                        this.add(place2);
                        for (Token t : this.getTokens(source, (CommandReply)transition.event)) {
                            place2.addToken(t);
                        }
                    }
                    this.inputs.add(new Input(place2, transition));
                    this.outputs.add(new Output(place2, transition, null));
                }
            } else if (transition.event instanceof EventCall && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY && this.getTokens(source, (EventCall)transition.event).size() > 0) {
                place2 = Place.forParameters(transition, source.state);
                if (!this.places.containsKey(place2.name)) {
                    this.add(place2);
                    for (Token t : this.getTokens(source, (EventCall)transition.event)) {
                        place2.addToken(t);
                    }
                }
                this.inputs.add(new Input(place2, transition));
                this.outputs.add(new Output(place2, transition, null));
            }
            boolean isTriggered = transition.event instanceof TriggeredTransition;
            boolean bl = addTokens = isTriggered && this.mode != ParameterPlaceMode.TRIGGERED_EMPTY_NONTRIGGERED_NONE;
            if (!isTriggered && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY) continue;
            Place place3 = place = addTokens ? Place.forParameters(transition, source.state) : Place.forParameters(transition);
            if (!this.places.containsKey(place.name)) {
                this.add(place);
                if (addTokens) {
                    for (Token t : this.getTokens(source, (TriggeredTransition)transition.event)) {
                        place.addToken(t);
                    }
                }
            }
            this.inputs.add(new Input(place, transition));
            if (!addTokens) continue;
            this.outputs.add(new Output(place, transition, null));
        }
        Place variablesPlace = this.add(Place.forVariables());
        variablesPlace.addToken(Token.forVariables(this.globalVariables));
        this.outputs.stream().filter(o -> o.place.type == Place.PPlaceType.STATE).collect(Collectors.toList()).forEach(o -> {
            boolean bl = this.outputs.add(new Output(variablesPlace, o.transition));
        });
        this.inputs.stream().filter(i -> i.place.type == Place.PPlaceType.STATE).collect(Collectors.toList()).forEach(i -> {
            boolean bl = this.inputs.add(new Input(variablesPlace, i.transition));
        });
        return this;
    }

    private Place getSource(PTransition transition) {
        List inputs = this.inputs.stream().filter(i -> i.transition == transition && i.place.type != Place.PPlaceType.VARIABLES).collect(Collectors.toList());
        assert (inputs.size() == 1);
        return ((Input)inputs.get((int)0)).place;
    }

    private RetVal needsTransitionToBeSkipped(Place place, TriggeredTransition e) {
        if (e == null) {
            return RetVal.NONE;
        }
        if (this.params != null) {
            for (TriggerParams triggerParams : this.params.getTriggerParams()) {
                if (triggerParams.getEvent() != e.getTrigger()) continue;
                for (StateParams stateParams : triggerParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    if (this.skipValue(stateParams)) {
                        return RetVal.SKIP;
                    }
                    if (stateParams.getBreak() == null) continue;
                    return RetVal.BREAK;
                }
            }
        }
        return RetVal.NONE;
    }

    private RetVal needsTransitionToBeSkipped(Place place, NonTriggeredTransition e) {
        if (e == null || e.getClauses().size() > 1) {
            return RetVal.NONE;
        }
        RetVal rVal = RetVal.NONE;
        for (Clause c : e.getClauses()) {
            if (c.getActions() == null) {
                return RetVal.NONE;
            }
            for (Action a : c.getActions().getActions()) {
                RetVal tmp;
                if (a instanceof EventWithVars) {
                    tmp = this.needsActionToBeSkipped(place, (EventWithVars)a);
                    rVal = rVal != RetVal.NONE ? rVal : tmp;
                    continue;
                }
                if (!(a instanceof EventCall)) continue;
                tmp = this.needsActionToBeSkipped(place, (EventCall)a);
                RetVal retVal = rVal = rVal != RetVal.NONE ? rVal : tmp;
            }
        }
        return rVal;
    }

    private RetVal needsClauseToBeSkipped(Place place, Clause c) {
        if (c == null || c.getActions() == null) {
            return RetVal.NONE;
        }
        RetVal rVal = RetVal.NONE;
        for (Action a : c.getActions().getActions()) {
            RetVal tmp = RetVal.NONE;
            if (a instanceof CommandReply) {
                tmp = this.needsActionToBeSkipped(place, (CommandReply)a);
            } else if (a instanceof EventWithVars) {
                tmp = this.needsActionToBeSkipped(place, (EventWithVars)a);
            } else if (a instanceof EventCall) {
                tmp = this.needsActionToBeSkipped(place, (EventCall)a);
            }
            RetVal retVal = rVal = rVal != RetVal.NONE ? rVal : tmp;
        }
        return rVal;
    }

    private RetVal needsActionToBeSkipped(Place place, EventCall n) {
        RetVal rVal = RetVal.NONE;
        if (this.params != null) {
            RetVal tmp = RetVal.NONE;
            tmp = this.needsTriggerToBeSkipped(place, n);
            rVal = rVal != RetVal.NONE ? rVal : tmp;
            tmp = this.needsNotificationToBeSkipped(place, n);
            rVal = rVal != RetVal.NONE ? rVal : tmp;
        }
        return rVal;
    }

    private RetVal needsActionToBeSkipped(Place place, EventWithVars n) {
        RetVal rVal = RetVal.NONE;
        if (this.params != null) {
            RetVal tmp = RetVal.NONE;
            tmp = this.needsTriggerToBeSkipped(place, n);
            rVal = rVal != RetVal.NONE ? rVal : tmp;
            tmp = this.needsNotificationToBeSkipped(place, n);
            rVal = rVal != RetVal.NONE ? rVal : tmp;
        }
        return rVal;
    }

    private RetVal needsTriggerToBeSkipped(Place place, EventCall n) {
        RetVal rVal = RetVal.NONE;
        for (TriggerParams tParams : this.params.getTriggerParams()) {
            if (tParams.getEvent() != n.getEvent()) continue;
            for (StateParams stateParams : tParams.getStateParams()) {
                RetVal tmp = this.skipStateOrParameter(place, n, stateParams);
                RetVal retVal = rVal = rVal != RetVal.NONE ? rVal : tmp;
            }
        }
        return rVal;
    }

    private RetVal needsTriggerToBeSkipped(Place place, EventWithVars n) {
        RetVal rVal = RetVal.NONE;
        for (TriggerParams tParams : this.params.getTriggerParams()) {
            if (tParams.getEvent() != n.getEvent()) continue;
            for (StateParams stateParams : tParams.getStateParams()) {
                RetVal tmp = this.skipStateOrParameter(place, n, stateParams);
                RetVal retVal = rVal = rVal != RetVal.NONE ? rVal : tmp;
            }
        }
        return rVal;
    }

    private RetVal needsNotificationToBeSkipped(Place place, EventCall n) {
        RetVal rVal = RetVal.NONE;
        for (NotificationParams nParams : this.params.getNotificationParams()) {
            if (nParams.getEvent() != n.getEvent()) continue;
            for (StateParams stateParams : nParams.getStateParams()) {
                RetVal tmp = this.skipStateOrParameter(place, n, stateParams);
                RetVal retVal = rVal = rVal != RetVal.NONE ? rVal : tmp;
            }
        }
        return rVal;
    }

    private RetVal needsNotificationToBeSkipped(Place place, EventWithVars n) {
        RetVal rVal = RetVal.NONE;
        for (NotificationParams nParams : this.params.getNotificationParams()) {
            if (nParams.getEvent() != n.getEvent()) continue;
            for (StateParams stateParams : nParams.getStateParams()) {
                RetVal tmp = this.skipStateOrParameter(place, n, stateParams);
                RetVal retVal = rVal = rVal != RetVal.NONE ? rVal : tmp;
            }
        }
        return rVal;
    }

    private RetVal skipStateOrParameter(Place place, EventCall n, StateParams stateParams) {
        Function<String, String> variablePrefix = variable -> "";
        if (stateParams.getState() == place.state) {
            if (this.skipValue(stateParams)) {
                return RetVal.SKIP;
            }
            if (stateParams.getBreak() != null) {
                return RetVal.BREAK;
            }
            for (Expression p : n.getParameters()) {
                String expStr1 = PythonHelper.expression(p, variablePrefix);
                for (Params param : stateParams.getParams()) {
                    for (Expression exp : param.getValue()) {
                        String expStr2 = PythonHelper.expression(exp, variablePrefix);
                        if (!expStr1.equals(expStr2) || param.getSkip() == null) continue;
                        return RetVal.SKIP;
                    }
                }
            }
        }
        return RetVal.NONE;
    }

    private RetVal skipStateOrParameter(Place place, EventWithVars n, StateParams stateParams) {
        if (stateParams.getState() == place.state) {
            if (this.skipValue(stateParams)) {
                return RetVal.SKIP;
            }
            if (stateParams.getBreak() != null) {
                return RetVal.BREAK;
            }
        }
        return RetVal.NONE;
    }

    private RetVal needsActionToBeSkipped(Place place, CommandReply e) {
        Function<String, String> variablePrefix = variable -> "";
        if (this.params != null) {
            for (ReplyParams rParams : this.params.getReplyParams()) {
                for (Expression p : e.getParameters()) {
                    String expStr1 = PythonHelper.expression(p, variablePrefix);
                    for (StateParams stateParams : rParams.getStateParams()) {
                        if (stateParams.getState() != place.state) continue;
                        for (Params param : stateParams.getParams()) {
                            for (Expression exp : param.getValue()) {
                                String expStr2 = PythonHelper.expression(exp, variablePrefix);
                                if (!expStr1.equals(expStr2) || param.getSkip() == null) continue;
                                return RetVal.SKIP;
                            }
                        }
                    }
                }
            }
        }
        return RetVal.NONE;
    }

    private List<Token> getTokens(Place place, EventWithVars n) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (this.params != null) {
            for (NotificationParams nParams : this.params.getNotificationParams()) {
                if (nParams.getEvent() != n.getEvent()) continue;
                for (StateParams stateParams : nParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        if (p.getSkip() != null) continue;
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        if (result.isEmpty()) {
            result.add(Token.forParameters(new ArrayList<Expression>()));
        }
        return result;
    }

    private List<Token> getTokens(Place place, EventCall n) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (this.params != null) {
            for (NotificationParams nParams : this.params.getNotificationParams()) {
                if (nParams.getEvent() != n.getEvent()) continue;
                for (StateParams stateParams : nParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        if (p.getSkip() != null) continue;
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        return result;
    }

    private List<Token> getTokens(Place place, CommandReply r) {
        ArrayList<Token> result = new ArrayList<Token>();
        InterfaceEvent command = ((TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)r, TriggeredTransition.class)).getTrigger();
        if (this.params != null) {
            for (ReplyParams rParams : this.params.getReplyParams()) {
                if (rParams.getEvent() != command) continue;
                for (StateParams stateParams : rParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        if (p.getSkip() != null) continue;
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        return result;
    }

    private List<Token> getTokens(Place place, CommandReplyWithVars r) {
        ArrayList<Token> result = new ArrayList<Token>();
        InterfaceEvent command = ((TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)r, TriggeredTransition.class)).getTrigger();
        if (this.params != null) {
            for (ReplyParams rParams : this.params.getReplyParams()) {
                if (rParams.getEvent() != command) continue;
                for (StateParams stateParams : rParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        if (p.getSkip() != null) continue;
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        if (result.isEmpty()) {
            result.add(Token.forParameters(new ArrayList<Expression>()));
        }
        return result;
    }

    private List<Token> getTokens(Place place, TriggeredTransition event) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (this.params != null) {
            for (TriggerParams triggerParams : this.params.getTriggerParams()) {
                if (triggerParams.getEvent() != event.getTrigger()) continue;
                for (StateParams stateParams : triggerParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        if (p.getSkip() != null) continue;
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        if (result.isEmpty() && event.getTrigger().getParameters().stream().anyMatch(s -> s.getDirection() != DIRECTION.OUT)) {
            throw new RuntimeException(String.format("No parameters provided for: '%s'", event.getTrigger().getName()));
        }
        if (result.isEmpty()) {
            result.add(Token.forParameters(new ArrayList<Expression>()));
        }
        return result;
    }

    private void addClause(Transition transition, List<Action> actions, Place start, Place end, TriggeredTransition trigger, boolean breakpoint) {
        ArrayList<Object> outputActions = new ArrayList<Action>();
        boolean skipLastTranstion = false;
        for (Action action : actions) {
            IfAction a;
            if (action instanceof AssignmentAction || action instanceof RecordFieldAssignmentAction) {
                outputActions.add(action);
                continue;
            }
            if (action instanceof IfAction) {
                a = (IfAction)action;
                Place splitPlace = this.add(Place.forClause(start, String.format("%d_split", actions.indexOf(action))));
                this.add(new PTransition(transition, this.component, breakpoint), start, splitPlace, outputActions);
                outputActions = new ArrayList();
                start = this.add(Place.forClause(start, String.format("%d_join", actions.indexOf(action))));
                Place ifPlace = this.add(Place.forClauseNest(splitPlace, "if_0"));
                this.add(new PTransition(transition, new Guard(a.getGuard(), GuardContext.IF_THEN_ELSE), this.component, breakpoint), splitPlace, ifPlace, outputActions);
                this.addClause(transition, (List<Action>)a.getThenList().getActions(), ifPlace, start, trigger, breakpoint);
                Place elsePlace = this.add(Place.forClauseNest(splitPlace, "else_0"));
                this.add(new PTransition(transition, new Guard(a.getGuard(), GuardContext.IF_THEN_ELSE, true), this.component, breakpoint), splitPlace, elsePlace, outputActions);
                this.addClause(transition, (List<Action>)(a.getElseList() == null ? new ArrayList() : a.getElseList().getActions()), elsePlace, start, trigger, breakpoint);
                outputActions = new ArrayList();
                continue;
            }
            if (action instanceof ActionWithVars) {
                Place actionEnd;
                ActionWithVars ev = (ActionWithVars)action;
                if (!outputActions.isEmpty()) {
                    Place next = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action))));
                    this.add(new PTransition(transition, this.component, breakpoint), start, next, outputActions);
                    start = next;
                    outputActions = new ArrayList();
                }
                if (actions.indexOf(action) == actions.size() - 1) {
                    actionEnd = end;
                    skipLastTranstion = true;
                } else {
                    actionEnd = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action) + 1)));
                }
                Guard guard = ev.getCondition() != null ? new Guard(ev.getCondition(), GuardContext.ACTION_WITH_VARS) : null;
                this.add(new PTransition(transition, action, guard, null, this.component, breakpoint), start, actionEnd, null);
                start = actionEnd;
                continue;
            }
            if (action instanceof CommandReply || action instanceof EventCall) {
                Place actionEnd;
                if (!outputActions.isEmpty()) {
                    Place next = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action))));
                    this.add(new PTransition(transition, this.component, breakpoint), start, next, outputActions);
                    start = next;
                    outputActions = new ArrayList();
                }
                if (actions.indexOf(action) == actions.size() - 1) {
                    actionEnd = end;
                    skipLastTranstion = true;
                } else {
                    actionEnd = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action) + 1)));
                }
                this.addMultiplicityAndOccurence(transition, action, start, actionEnd, trigger, breakpoint);
                start = actionEnd;
                continue;
            }
            if (action instanceof ParallelComposition) {
                a = (ParallelComposition)action;
                Place anyOrderPlace = this.add(Place.forClause(start, String.format("%d_anyorder", actions.indexOf(action))));
                this.add(new PTransition(transition, this.component, breakpoint), start, anyOrderPlace, outputActions);
                outputActions = new ArrayList();
                PTransition anyOrderTransition = this.add(new PTransition(transition, this.component, breakpoint), anyOrderPlace, null, null);
                Place joinPlace = this.add(Place.forClause(start, String.format("%d_join", actions.indexOf(action))));
                PTransition joinTransition = this.add(new PTransition(transition, this.component, breakpoint), null, joinPlace, null);
                ArrayList pcActions = new ArrayList();
                a.getComponents().forEach(e -> {
                    class RecursiveHelper {
                        final Consumer<PCElement> addRecursive = element -> {
                            if (element instanceof PCFragmentReference) {
                                ((PCFragmentReference)element).getFragment().getComponents().forEach(e -> this.addRecursive.accept((PCElement)e));
                            } else {
                                list.add((Action)element);
                            }
                        };
                        private final /* synthetic */ List val$pcActions;

                        RecursiveHelper(List list) {
                            this.val$pcActions = list;
                        }
                    }
                    (Petrinet)this.new RecursiveHelper((List)list).addRecursive.accept((PCElement)e);
                });
                for (Action pcAction : pcActions) {
                    Place elementStart = this.add(Place.forClause(start, String.format("%d_anyorder_%d_start", actions.indexOf(action), pcActions.indexOf(pcAction))));
                    Place elementEnd = this.add(Place.forClause(start, String.format("%d_anyorder_%d_end", actions.indexOf(action), pcActions.indexOf(pcAction))));
                    this.outputs.add(new Output(elementStart, anyOrderTransition, null));
                    this.inputs.add(new Input(elementEnd, joinTransition));
                    this.addClause(transition, Arrays.asList(pcAction), elementStart, elementEnd, trigger, breakpoint);
                }
                start = joinPlace;
                continue;
            }
            assert (false) : "Not supported";
        }
        if (!skipLastTranstion) {
            if (!outputActions.isEmpty() && end.state != null) {
                Place next = this.add(Place.forClause(start, Integer.toString(actions.size())));
                this.add(new PTransition(transition, this.component, breakpoint), start, next, outputActions);
                start = next;
                outputActions = new ArrayList();
            }
            this.add(new PTransition(transition, this.component, breakpoint), start, end, outputActions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addMultiplicityAndOccurence(Transition transition, Action action, Place start, Place end, TriggeredTransition trigger, boolean breakpoint) {
        long max;
        long min;
        if (!(action instanceof EventCall) || ((EventCall)action).getMultiplicity() == null && ((EventCall)action).getOccurence() == null) {
            this.add(new PTransition(transition, action, null, trigger, this.component, breakpoint), start, end, null);
            return;
        }
        EventCall event = (EventCall)action;
        Multiplicity multiplicity = event.getMultiplicity();
        String occurence = event.getOccurence();
        assert (multiplicity != null || occurence != null);
        if (occurence != null) {
            if (occurence.equals("?")) {
                min = 0L;
                max = 1L;
            } else if (occurence.equals("+")) {
                min = 1L;
                max = -1L;
            } else {
                if (!occurence.equals("*")) throw new RuntimeException("Not supported");
                min = 0L;
                max = -1L;
            }
        } else {
            min = multiplicity.getLower();
            max = multiplicity.getUpperInf() != null ? -1L : multiplicity.getUpper();
        }
        List startOutputs = this.outputs.stream().filter(o -> o.place == start).collect(Collectors.toList());
        if (startOutputs.size() != 1) {
            throw new RuntimeException("Not allowed");
        }
        if (min != 0L || max != -1L) {
            ((Output)startOutputs.get((int)0)).repeatAction = Output.RepeatAction.INIT;
        }
        Guard minGuard = min != 0L ? new Guard(Guard.PRepeatGuardType.MIN, min) : null;
        this.add(new PTransition(transition, minGuard, this.component, breakpoint), start, end, null);
        if (max == 0L) return;
        Guard maxGuard = max != -1L ? new Guard(Guard.PRepeatGuardType.MAX, max) : null;
        this.add(new PTransition(transition, event, maxGuard, null, this.component, breakpoint), start, start, null);
        if (min == 0L && max == -1L) return;
        this.outputs.get((int)(this.outputs.size() - 1)).repeatAction = max == -1L ? Output.RepeatAction.SET_1 : Output.RepeatAction.INCREASE;
    }

    private PTransition add(PTransition transition, Place from, Place to, List<Action> outputActions) {
        this.transitions.add(transition);
        if (from != null) {
            this.inputs.add(new Input(from, transition));
        }
        if (to != null) {
            this.outputs.add(new Output(to, transition, outputActions));
        }
        return transition;
    }

    private Place add(Place place) {
        if (this.places.containsKey(place.name)) {
            return this.places.get(place.name);
        }
        this.places.put(place.name, place);
        return place;
    }

    public String toPython(String netFunctionName) {
        StringBuilder builder = new StringBuilder();
        builder.append("def " + netFunctionName + "():\n" + "    n = PetriNet(\"N\")\n" + "\n" + "    def add_place(place: Place, meta: Dict[str, Any]):\n" + "        n.add_place(place)\n" + "        place.meta = meta\n" + "\n" + "    def add_transition(transition: Transition, meta: Dict[str, Any]):\n" + "        n.add_transition(transition)\n" + "        transition.meta = meta\n" + "\n");
        Function<String, String> variablePrefix = variable -> this.globalVariables.contains(variable) ? "g." : "l.";
        ArrayList<Variable> vars = new ArrayList<Variable>();
        if (this.params != null) {
            for (TriggerParams tp : this.params.getTriggerParams()) {
                vars.addAll(this.getImportedOtherVariables((EList<StateOtherParams>)tp.getStateParams()));
            }
            for (TriggerParams tp : this.params.getNotificationParams()) {
                vars.addAll(this.getImportedOtherVariables((EList<StateOtherParams>)tp.getStateParams()));
            }
            for (TriggerParams tp : this.params.getReplyParams()) {
                vars.addAll(this.getImportedReplyVariables((EList<StateReplyParams>)tp.getStateParams()));
            }
        }
        builder.append("    # Variables\n");
        this.itf.getVars().forEach(v -> {
            StringBuilder stringBuilder2 = builder.append(String.format("    v_%s = %s\n", v.getName(), PythonHelper.defaultValue(TypeUtilities.getTypeObject((Type)v.getType()))));
        });
        if (this.params != null) {
            List<Object> variables = new ArrayList<Variable>();
            variables.addAll((Collection<Object>)this.params.getVars());
            variables.addAll(vars);
            variables = variables.stream().distinct().collect(Collectors.toList());
            variables.forEach(v -> {
                StringBuilder stringBuilder2 = builder.append(String.format("    p_%s = %s\n", v.getName(), PythonHelper.defaultValue(TypeUtilities.getTypeObject((Type)v.getType()))));
            });
        }
        builder.append("\n    # Init\n");
        this.itf.getInitActions().forEach(a -> {
            StringBuilder stringBuilder2 = builder.append("    " + PythonHelper.action(a, variable -> "v_", false, false) + "\n");
        });
        if (this.params != null) {
            List<Object> actions = new ArrayList();
            actions.addAll((Collection<Object>)this.params.getInitActions());
            for (Variable v2 : vars) {
                EObject con = v2.eContainer();
                if (!(con instanceof Parameters)) continue;
                for (Action a2 : ((Parameters)con).getInitActions()) {
                    actions.add(a2);
                }
            }
            actions = actions.stream().distinct().collect(Collectors.toList());
            actions.forEach(a -> {
                StringBuilder stringBuilder2 = builder.append("    " + PythonHelper.action(a, variable -> "p_", false, false) + "\n");
            });
        }
        builder.append("\n    # Places\n");
        this.places.values().forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(this.itf));
        });
        builder.append("\n    # Transitions\n");
        this.transitions.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(variablePrefix, this.itf, this.port, this.portDirection));
        });
        builder.append("\n    # Inputs \n");
        this.inputs.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(variablePrefix));
        });
        builder.append("\n    # Outputs\n");
        this.outputs.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(variablePrefix));
        });
        builder.append("    return n\n");
        return builder.toString();
    }

    private List<Variable> getImportedOtherVariables(EList<StateOtherParams> sps) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (StateOtherParams sp : sps) {
            for (Params p : sp.getParams()) {
                for (Expression e : p.getValue()) {
                    if (!(e instanceof ExpressionVariable)) continue;
                    vars.add(((ExpressionVariable)e).getVariable());
                }
            }
        }
        return vars;
    }

    private List<Variable> getImportedReplyVariables(EList<StateReplyParams> sps) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (StateReplyParams sp : sps) {
            for (Params p : sp.getParams()) {
                for (Expression e : p.getValue()) {
                    if (!(e instanceof ExpressionVariable)) continue;
                    vars.add(((ExpressionVariable)e).getVariable());
                }
            }
        }
        return vars;
    }

    private boolean skipValue(StateParams sp) {
        if (sp instanceof StateOtherParams) {
            StateOtherParams sop = (StateOtherParams)sp;
            return sop.getSkip() != null;
        }
        return false;
    }

    public static enum ParameterPlaceMode {
        TRIGGERED_EMPTY_NONTRIGGERED_NONE,
        TRIGGERED_FILLED_NONTRIGGERED_EMPTY,
        TRIGGERED_FILLED_NONTRIGGERED_NONE;

    }

    static enum RetVal {
        NONE,
        SKIP,
        BREAK;

    }
}

