/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import io.github.toolfactory.jvm.DefaultDriver;
import io.github.toolfactory.jvm.Driver;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class ReflectionUtils {
    private static Driver reflectionDriver = new DefaultDriver();

    private ReflectionUtils() {
    }

    private static Object getFieldVal(Class<?> cls, Object obj, String fieldName, boolean throwException) throws IllegalArgumentException {
        block4: {
            try {
                for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
                    for (Field field : reflectionDriver.getDeclaredFields(c)) {
                        if (!field.getName().equals(fieldName)) continue;
                        return reflectionDriver.getFieldValue(obj, field);
                    }
                }
            }
            catch (Exception e) {
                if (!throwException) break block4;
                throw new IllegalArgumentException("Can't read " + (obj == null ? "static " : "") + " field \"" + fieldName + "\": " + e);
            }
        }
        return null;
    }

    public static Object getFieldVal(Object obj, String fieldName, boolean throwException) throws IllegalArgumentException {
        if (obj == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.getFieldVal(obj.getClass(), obj, fieldName, throwException);
    }

    public static Object getStaticFieldVal(Class<?> cls, String fieldName, boolean throwException) throws IllegalArgumentException {
        if (cls == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.getFieldVal(cls, null, fieldName, throwException);
    }

    private static List<Method> enumerateMethods(Class<?> cls) {
        ArrayList<Method> methodOrder = new ArrayList<Method>();
        HashSet<GenericDeclaration> visited = new HashSet<GenericDeclaration>();
        LinkedList<GenericDeclaration> interfaceQueue = new LinkedList<GenericDeclaration>();
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            for (Method method : reflectionDriver.getDeclaredMethods(c)) {
                methodOrder.add(method);
            }
            if (c.isInterface() && visited.add(c)) {
                interfaceQueue.add(c);
            }
            for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                if (!visited.add(genericDeclaration)) continue;
                interfaceQueue.add(genericDeclaration);
            }
        }
        while (!interfaceQueue.isEmpty()) {
            Class iface = (Class)interfaceQueue.remove();
            for (GenericDeclaration genericDeclaration : reflectionDriver.getDeclaredMethods(iface)) {
                methodOrder.add((Method)genericDeclaration);
            }
            for (GenericDeclaration genericDeclaration : iface.getInterfaces()) {
                if (!visited.add(genericDeclaration)) continue;
                interfaceQueue.add(genericDeclaration);
            }
        }
        return methodOrder;
    }

    public static Object invokeMethod(Object obj, String methodName, boolean throwException) throws IllegalArgumentException {
        block5: {
            if (obj == null || methodName == null) {
                if (throwException) {
                    throw new IllegalArgumentException("Unexpected null argument");
                }
                return null;
            }
            try {
                for (Method m : ReflectionUtils.enumerateMethods(obj.getClass())) {
                    if (!m.getName().equals(methodName) || m.getParameterTypes().length != 0) continue;
                    return reflectionDriver.invoke(m, obj, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!throwException) break block5;
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object param, boolean throwException) throws IllegalArgumentException {
        block5: {
            if (obj == null || methodName == null || argType == null) {
                if (throwException) {
                    throw new IllegalArgumentException("Unexpected null argument");
                }
                return null;
            }
            try {
                for (Method m : ReflectionUtils.enumerateMethods(obj.getClass())) {
                    if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != argType) continue;
                    return reflectionDriver.invoke(m, obj, new Object[]{param});
                }
            }
            catch (Exception e) {
                if (!throwException) break block5;
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, boolean throwException) throws IllegalArgumentException {
        block5: {
            if (cls == null || methodName == null) {
                if (throwException) {
                    throw new IllegalArgumentException("Unexpected null argument");
                }
                return null;
            }
            try {
                for (Method m : ReflectionUtils.enumerateMethods(cls)) {
                    if (!m.getName().equals(methodName) || m.getParameterTypes().length != 0) continue;
                    return reflectionDriver.invoke(m, null, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!throwException) break block5;
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object param, boolean throwException) throws IllegalArgumentException {
        block5: {
            if (cls == null || methodName == null || argType == null) {
                if (throwException) {
                    throw new IllegalArgumentException("Unexpected null argument");
                }
                return null;
            }
            try {
                for (Method m : ReflectionUtils.enumerateMethods(cls)) {
                    if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != argType) continue;
                    return reflectionDriver.invoke(m, null, new Object[]{param});
                }
            }
            catch (Exception e) {
                if (!throwException) break block5;
                throw new IllegalArgumentException("Method \"" + methodName + "\" could not be invoked: " + e);
            }
        }
        return null;
    }

    public static Class<?> classForNameOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            return null;
        }
    }
}

