/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.iproduct.IRepositoryInfo;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.RepositoryDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class UpdatesSection
extends TableSection {
    private TableViewer fRepositoryTable;
    private TableEditor fEnabledColumnEditor;

    public UpdatesSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, UpdatesSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.UpdatesSection_add, PDEUIMessages.UpdatesSection_edit, PDEUIMessages.UpdatesSection_remove, PDEUIMessages.UpdatesSection_removeAll};
        return labels;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.verticalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 65538, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        EditableTablePart tablePart = this.getTablePart();
        this.fRepositoryTable = tablePart.getTableViewer();
        final Table table = this.fRepositoryTable.getTable();
        final TableColumn locationColumn = new TableColumn(table, 16384);
        locationColumn.setText(PDEUIMessages.UpdatesSection_LocationColumn);
        locationColumn.setWidth(240);
        final TableColumn enabledColumn = new TableColumn(table, 16384);
        enabledColumn.setText(PDEUIMessages.UpdatesSection_EnabledColumn);
        enabledColumn.setWidth(120);
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.minimumWidth = 200;
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable());
        table.setHeaderVisible(true);
        toolkit.paintBordersFor(container);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int size = table.getSize().x;
                locationColumn.setWidth(size / 6 * 5);
                enabledColumn.setWidth(size / 6 * 1);
            }
        });
        this.fRepositoryTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fRepositoryTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fRepositoryTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IRepositoryInfo r1 = (IRepositoryInfo)e1;
                IRepositoryInfo r2 = (IRepositoryInfo)e2;
                return super.compare(viewer, (Object)r1.getURL(), (Object)r2.getURL());
            }
        });
        this.fRepositoryTable.setInput((Object)this.getProduct());
        this.createEditors();
        section.setClient((Control)container);
        section.setText(PDEUIMessages.UpdatesSection_title);
        section.setDescription(PDEUIMessages.UpdatesSection_description);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit(this.fRepositoryTable.getStructuredSelection());
                break;
            }
            case 2: {
                this.handleDelete();
                break;
            }
            case 3: {
                this.handleRemoveAll();
            }
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleEdit(selection);
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        return super.doGlobalAction(actionId);
    }

    private void handleEdit(IStructuredSelection selection) {
        IRepositoryInfo repoInfo;
        RepositoryDialog dialog;
        this.clearEditors();
        if (!selection.isEmpty() && (dialog = this.getRepositoryDialog((repoInfo = (IRepositoryInfo)selection.toArray()[0]).getURL())).open() == 0) {
            this.updateModel(repoInfo, dialog.getResult());
        }
    }

    private RepositoryDialog getRepositoryDialog(String repoURL) {
        RepositoryDialog dialog = new RepositoryDialog(PDEPlugin.getActiveWorkbenchShell(), repoURL);
        dialog.setTitle(PDEUIMessages.UpdatesSection_RepositoryDialogTitle);
        return dialog;
    }

    private void updateModel(IRepositoryInfo pRepositoryInfo, String pURL) {
        if (pRepositoryInfo != null) {
            this.getProduct().removeRepositories(new IRepositoryInfo[]{pRepositoryInfo});
        }
        IProductModelFactory factory = this.getModel().getFactory();
        IRepositoryInfo repo = factory.createRepositoryInfo();
        repo.setURL(pURL.trim());
        repo.setEnabled(true);
        this.getProduct().addRepositories(new IRepositoryInfo[]{repo});
        this.fRepositoryTable.refresh();
        this.fRepositoryTable.setSelection((ISelection)new StructuredSelection((Object)repo));
        this.updateButtons();
    }

    private void handleDelete() {
        this.clearEditors();
        IStructuredSelection ssel = this.fRepositoryTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            Object[] objects = ssel.toArray();
            IRepositoryInfo[] repos = new IRepositoryInfo[objects.length];
            System.arraycopy(objects, 0, repos, 0, objects.length);
            this.getProduct().removeRepositories(repos);
            this.fRepositoryTable.refresh(false);
            this.updateButtons();
        }
    }

    private void handleRemoveAll() {
        this.clearEditors();
        this.getProduct().removeRepositories(this.getProduct().getRepositories());
        this.fRepositoryTable.refresh(false);
        this.updateButtons();
    }

    private void handleAdd() {
        this.clearEditors();
        RepositoryDialog dialog = this.getRepositoryDialog(null);
        if (dialog.open() == 0) {
            this.updateModel(null, dialog.getResult());
        }
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void refresh() {
        this.fRepositoryTable.refresh();
        this.updateButtons();
        super.refresh();
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IProductPlugin) {
            this.fRepositoryTable.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.fRepositoryTable.setInput((Object)this.getProduct());
        this.fRepositoryTable.refresh();
        this.updateButtons();
        this.clearEditors();
    }

    private void updateButtons() {
        EditableTablePart tablePart = this.getTablePart();
        IStructuredSelection selection = this.getViewerSelection();
        boolean enabled = this.isEditable() && !selection.isEmpty() && selection instanceof IStructuredSelection && selection.getFirstElement() instanceof IRepositoryInfo;
        tablePart.setButtonEnabled(1, enabled);
        tablePart.setButtonEnabled(2, enabled);
        tablePart.setButtonEnabled(3, this.isEditable() && this.getProduct().getRepositories().length > 0);
    }

    private void clearEditors() {
        Control oldEditor = this.fEnabledColumnEditor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }

    private void createEditors() {
        Table table = this.fRepositoryTable.getTable();
        this.fEnabledColumnEditor = new TableEditor(table);
        this.fEnabledColumnEditor.horizontalAlignment = 0x1000000;
        this.fEnabledColumnEditor.grabHorizontal = true;
        this.fEnabledColumnEditor.minimumWidth = 50;
        table.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showControls()));
    }

    private void showControls() {
        this.clearEditors();
        Table table = this.fRepositoryTable.getTable();
        IStructuredSelection selection = this.fRepositoryTable.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        TableItem item = table.getSelection()[0];
        if (item != null && !this.isEditable()) {
            return;
        }
        if (item != null) {
            IRepositoryInfo repo = (IRepositoryInfo)selection.getFirstElement();
            CCombo combo = new CCombo((Composite)table, 2056);
            combo.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
            combo.setText(item.getText(1));
            combo.pack();
            combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                item.setText(1, combo.getText());
                repo.setEnabled(Boolean.parseBoolean(combo.getText()));
            }));
            this.fEnabledColumnEditor.setEditor((Control)combo, item, 1);
        }
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProduct) {
                return ((IProduct)inputElement).getRepositories();
            }
            return new Object[0];
        }
    }

    private class LabelProvider
    extends PDELabelProvider {
        private LabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.get(PDEPluginImages.DESC_REPOSITORY_OBJ);
            }
            return null;
        }

        @Override
        public String getColumnText(Object obj, int index) {
            IRepositoryInfo repo = (IRepositoryInfo)obj;
            switch (index) {
                case 0: {
                    return repo.getURL();
                }
                case 1: {
                    return Boolean.toString(repo.getEnabled());
                }
            }
            return null;
        }
    }
}

