/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.StatefulResourceDescription;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResult;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResultEvents;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewTreeNode;

public class ReferenceSearchResultContentProvider
implements ITreeContentProvider,
ISearchResultListener,
IResourceDescription.Event.Listener {
    private IResourceDescriptions resourceDescriptions;
    private List<ReferenceSearchViewTreeNode> rootNodes;
    private TreeViewer viewer;
    private List<SearchResultEvent> batchedSearchResultEvents = new ArrayList<SearchResultEvent>();
    private volatile boolean isUIUpdateScheduled;

    @Inject
    public ReferenceSearchResultContentProvider(IResourceDescriptions resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
        this.attachListenerToIndex(resourceDescriptions);
    }

    protected void attachListenerToIndex(IResourceDescriptions resourceDescriptions) {
        if (resourceDescriptions instanceof IResourceDescription.Event.Source) {
            ((IResourceDescription.Event.Source)resourceDescriptions).addListener((IResourceDescription.Event.Listener)this);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ReferenceSearchViewTreeNode) {
            return ((ReferenceSearchViewTreeNode)parentElement).getChildren().toArray(new ReferenceSearchViewTreeNode[0]);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ReferenceSearchViewTreeNode) {
            return ((ReferenceSearchViewTreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ReferenceSearchViewTreeNode) {
            return !((ReferenceSearchViewTreeNode)element).getChildren().isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.rootNodes == null || this.rootNodes.isEmpty()) {
            return new Object[0];
        }
        return this.rootNodes.toArray(new ReferenceSearchViewTreeNode[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.detachListenerFromIndex();
        this.rootNodes = null;
        List<SearchResultEvent> list = this.batchedSearchResultEvents;
        synchronized (list) {
            this.batchedSearchResultEvents.clear();
        }
        super.dispose();
    }

    protected void detachListenerFromIndex() {
        if (this.resourceDescriptions instanceof IResourceDescription.Event.Source) {
            ((IResourceDescription.Event.Source)this.resourceDescriptions).removeListener((IResourceDescription.Event.Listener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Viewer viewer2 = viewer;
        synchronized (viewer2) {
            if (this.rootNodes != null) {
                this.rootNodes.clear();
            }
            if (oldInput instanceof ReferenceSearchResult) {
                ((ReferenceSearchResult)oldInput).removeListener(this);
            }
            if (newInput instanceof ReferenceSearchResult && viewer instanceof TreeViewer) {
                ((ReferenceSearchResult)newInput).addListener(this);
                this.viewer = (TreeViewer)viewer;
                for (IReferenceDescription referenceDescription : ((ReferenceSearchResult)newInput).getMatchingReferences()) {
                    this.addReference(referenceDescription, false);
                }
            }
        }
    }

    private void addReference(IReferenceDescription referenceDescription, boolean isUpdateViewer) {
        URI containerEObjectURI = referenceDescription.getContainerEObjectURI();
        URI eObjectURI = containerEObjectURI == null ? referenceDescription.getSourceEObjectUri() : containerEObjectURI;
        IResourceDescription resourceDescription = this.resourceDescriptions.getResourceDescription(eObjectURI.trimFragment());
        if (resourceDescription != null) {
            ReferenceSearchViewTreeNode resourceNode = this.resourceNode(resourceDescription, isUpdateViewer);
            ReferenceSearchViewTreeNode referenceNode = null;
            for (IEObjectDescription eObjectDescription : resourceDescription.getExportedObjects()) {
                if (!eObjectDescription.getEObjectURI().equals(eObjectURI)) continue;
                referenceNode = new ReferenceSearchViewTreeNode(resourceNode, referenceDescription, eObjectDescription);
                break;
            }
            if (referenceNode == null && resourceNode != null) {
                new ReferenceSearchViewTreeNode(resourceNode, referenceDescription, referenceDescription);
            }
        }
    }

    private ReferenceSearchViewTreeNode resourceNode(IResourceDescription resourceDescription, boolean isUpdateViewer) {
        ReferenceSearchViewTreeNode node2;
        if (this.rootNodes == null) {
            this.rootNodes = new ArrayList<ReferenceSearchViewTreeNode>();
        }
        for (ReferenceSearchViewTreeNode node2 : this.rootNodes) {
            Object nodeDescription = node2.getDescription();
            if (!(nodeDescription instanceof IResourceDescription) || !((IResourceDescription)nodeDescription).getURI().equals(resourceDescription.getURI())) continue;
            return node2;
        }
        node2 = new ReferenceSearchViewTreeNode(null, resourceDescription, resourceDescription);
        this.rootNodes.add(node2);
        if (isUpdateViewer) {
            this.viewer.add(this.viewer.getInput(), (Object)node2);
        }
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchResultChanged(SearchResultEvent e) {
        List<SearchResultEvent> list = this.batchedSearchResultEvents;
        synchronized (list) {
            this.batchedSearchResultEvents.add(e);
        }
        if (!this.isUIUpdateScheduled) {
            this.isUIUpdateScheduled = true;
            new UIUpdater().schedule();
        }
    }

    private void expandToFirstChild() {
        if (this.rootNodes != null && !this.rootNodes.isEmpty()) {
            Object[] rootNodesArray = this.rootNodes.toArray(new ReferenceSearchViewTreeNode[0]);
            this.viewer.getComparator().sort((Viewer)this.viewer, rootNodesArray);
            Object topElement = rootNodesArray[0];
            Object[] firstChildren = ((ReferenceSearchViewTreeNode)topElement).getChildren().toArray();
            if (firstChildren.length > 0) {
                this.viewer.getComparator().sort((Viewer)this.viewer, firstChildren);
                this.viewer.setSelection((ISelection)new StructuredSelection(firstChildren[0]), true);
            }
        }
    }

    public void descriptionsChanged(final IResourceDescription.Event event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ReferenceSearchResultContentProvider.this.rootNodes != null) {
                    block0: for (IResourceDescription.Delta delta : event.getDeltas()) {
                        if (delta.getNew() instanceof StatefulResourceDescription) continue;
                        Iterator i = ReferenceSearchResultContentProvider.this.rootNodes.iterator();
                        while (i.hasNext()) {
                            ReferenceSearchViewTreeNode rootNode = (ReferenceSearchViewTreeNode)i.next();
                            if (!((IResourceDescription)rootNode.getDescription()).getURI().equals(delta.getUri())) continue;
                            if (delta.getNew() == null) {
                                i.remove();
                                ReferenceSearchResultContentProvider.this.viewer.remove((Object)rootNode);
                                continue block0;
                            }
                            Iterable newReferenceDescriptions = delta.getNew().getReferenceDescriptions();
                            ArrayList<ReferenceSearchViewTreeNode> removedReferenceNodes = new ArrayList<ReferenceSearchViewTreeNode>();
                            for (ReferenceSearchViewTreeNode referenceNode : rootNode.getChildren()) {
                                URI referenceSourceURI = ((IReferenceDescription)referenceNode.getDescription()).getSourceEObjectUri();
                                if (Iterables.any((Iterable)newReferenceDescriptions, input -> input.getSourceEObjectUri().equals(referenceSourceURI))) continue;
                                removedReferenceNodes.add(referenceNode);
                            }
                            for (ReferenceSearchViewTreeNode removedReferenceNode : removedReferenceNodes) {
                                rootNode.removeChild(removedReferenceNode);
                            }
                            if (rootNode.getChildren().isEmpty()) {
                                i.remove();
                                ReferenceSearchResultContentProvider.this.viewer.remove((Object)rootNode);
                                continue block0;
                            }
                            ReferenceSearchResultContentProvider.this.viewer.remove((Object)rootNode, removedReferenceNodes.toArray());
                        }
                    }
                }
            }
        });
    }

    public void remove(ReferenceSearchViewTreeNode ... nodes) {
        ReferenceSearchViewTreeNode[] referenceSearchViewTreeNodeArray = nodes;
        int n2 = nodes.length;
        int n3 = 0;
        while (n3 < n2) {
            ReferenceSearchViewTreeNode node = referenceSearchViewTreeNodeArray[n3];
            if (!this.rootNodes.remove(node)) {
                this.rootNodes.forEach(n -> this.remove(node, (ReferenceSearchViewTreeNode)n));
            }
            ++n3;
        }
    }

    protected void remove(ReferenceSearchViewTreeNode toRemove, ReferenceSearchViewTreeNode from) {
        from.removeChild(toRemove);
        from.getChildren().forEach(childNode -> this.remove(toRemove, (ReferenceSearchViewTreeNode)childNode));
    }

    private class UIUpdater
    extends UIJob {
        public UIUpdater() {
            super(Messages.ReferenceSearchResultContentProvider_label);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList events;
            ReferenceSearchResultContentProvider.this.isUIUpdateScheduled = false;
            List list = ReferenceSearchResultContentProvider.this.batchedSearchResultEvents;
            synchronized (list) {
                events = new ArrayList(ReferenceSearchResultContentProvider.this.batchedSearchResultEvents);
                ReferenceSearchResultContentProvider.this.batchedSearchResultEvents.clear();
            }
            for (SearchResultEvent event : events) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (event instanceof ReferenceSearchResultEvents.Added) {
                    ReferenceSearchResultContentProvider.this.addReference(((ReferenceSearchResultEvents.Added)event).getReferenceDescription(), true);
                    continue;
                }
                if (!(event instanceof ReferenceSearchResultEvents.Reset) || ReferenceSearchResultContentProvider.this.rootNodes == null || ReferenceSearchResultContentProvider.this.rootNodes.isEmpty()) continue;
                TreeViewer treeViewer = ReferenceSearchResultContentProvider.this.viewer;
                synchronized (treeViewer) {
                    ReferenceSearchResultContentProvider.this.viewer.remove(ReferenceSearchResultContentProvider.this.viewer.getInput(), ReferenceSearchResultContentProvider.this.rootNodes.toArray());
                    ReferenceSearchResultContentProvider.this.rootNodes = null;
                }
            }
            ReferenceSearchResultContentProvider.this.viewer.refresh();
            ReferenceSearchResultContentProvider.this.expandToFirstChild();
            return Status.OK_STATUS;
        }
    }
}

