/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.xtext.ui.editor.preferences.FixedScopedPreferenceStore;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.eclipse.xtext.ui.internal.Activator;
import org.eclipse.xtext.util.Strings;

public class PreferenceStoreAccessor {
    private final String PREFERENCE_TAG;
    private final IPreferenceStoreAccess scopedAccessor;
    private final String CSS_PREFIX = "syntaxColorer.";
    @Inject
    private AbstractUIPlugin plugin;

    @Inject
    public PreferenceStoreAccessor(@Named(value="languageName") String languageName, IPreferenceStoreAccess scopedAccessor) {
        this.PREFERENCE_TAG = String.valueOf(PreferenceStoreAccessor.tokenTypeTag(languageName)) + '.';
        this.scopedAccessor = scopedAccessor;
    }

    public void populateTextStyle(String id, TextStyle style, TextStyle defaults) {
        Object[] fontDataArray;
        RGB background;
        IPreferenceStore editorsStore = EditorsUI.getPreferenceStore();
        RGB fontColorSystemDefault = editorsStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? this.getDisplay().getSystemColor(24).getRGB() : PreferenceConverter.getColor((IPreferenceStore)editorsStore, (String)"AbstractTextEditor.Color.Foreground");
        RGB backgroundColorSystemDefault = editorsStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? this.getDisplay().getSystemColor(25).getRGB() : PreferenceConverter.getColor((IPreferenceStore)editorsStore, (String)"AbstractTextEditor.Color.Background");
        Object[] fontDataDefaultDefault = JFaceResources.getTextFont().getFontData();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String cssID = "syntaxColorer." + id;
        ChainedPreferenceStore cssPrefStore = this.getPluginCssPreferenceStore();
        String colorKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenColorPreferenceKey(id);
        String cssFontColor = cssPrefStore.getString(PreferenceStoreAccessor.getTokenColorPreferenceKey(cssID));
        if (!Strings.isEmpty((String)cssFontColor)) {
            preferenceStore.setDefault(colorKey, cssFontColor);
        } else if (defaults.getColor() != null) {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)colorKey, (RGB)defaults.getColor());
        } else {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)colorKey, (RGB)fontColorSystemDefault);
        }
        String backgroundKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenBackgroundColorPreferenceKey(id);
        String cssBgColor = cssPrefStore.getString(PreferenceStoreAccessor.getTokenBackgroundColorPreferenceKey(cssID));
        if (!Strings.isEmpty((String)cssBgColor)) {
            preferenceStore.setDefault(backgroundKey, cssBgColor);
        } else if (defaults.getBackgroundColor() != null) {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)backgroundKey, (RGB)defaults.getBackgroundColor());
        } else {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)backgroundKey, (RGB)backgroundColorSystemDefault);
        }
        String fontKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenFontPreferenceKey(id);
        String cssFont = cssPrefStore.getString(PreferenceStoreAccessor.getTokenFontPreferenceKey(cssID));
        if (!Strings.isEmpty((String)cssFont)) {
            preferenceStore.setDefault(fontKey, cssFont);
        } else if (defaults.getFontData() != null) {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)fontKey, (FontData[])defaults.getFontData());
        } else {
            PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)fontKey, (FontData[])fontDataDefaultDefault);
        }
        String styleKey = String.valueOf(this.PREFERENCE_TAG) + PreferenceStoreAccessor.getTokenStylePreferenceKey(id);
        int cssStyle = cssPrefStore.getInt(PreferenceStoreAccessor.getTokenStylePreferenceKey(cssID));
        if (cssStyle != 0) {
            preferenceStore.setDefault(styleKey, cssStyle);
        } else {
            preferenceStore.setDefault(styleKey, defaults.getStyle());
        }
        RGB color = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)colorKey);
        if (!color.equals((Object)fontColorSystemDefault)) {
            style.setColor(color);
        }
        if (!(background = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)backgroundKey)).equals((Object)backgroundColorSystemDefault)) {
            style.setBackgroundColor(background);
        }
        if (!Arrays.equals(fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)preferenceStore, (String)fontKey), fontDataDefaultDefault)) {
            style.setFontData((FontData[])fontDataArray);
        }
        style.setStyle(preferenceStore.getInt(styleKey));
    }

    private ChainedPreferenceStore getPluginCssPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{new FixedScopedPreferenceStore((IScopeContext)new InstanceScope(), this.plugin.getBundle().getSymbolicName()), new FixedScopedPreferenceStore((IScopeContext)new InstanceScope(), Activator.getDefault().getBundle().getSymbolicName())});
    }

    private IPreferenceStore getPreferenceStore() {
        return this.scopedAccessor.getWritablePreferenceStore();
    }

    private Device getDisplay() {
        Display display = Display.getCurrent();
        return display == null ? Display.getDefault() : display;
    }

    public static String getTokenColorPreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "color";
    }

    public static String getTokenBackgroundColorPreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "bgColor";
    }

    public static String getTokenFontPreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "font";
    }

    public static String getTokenStylePreferenceKey(String tokenType) {
        return String.valueOf(tokenType) + '.' + "style";
    }

    public static String syntaxColorerTag(String languageName) {
        return String.valueOf(languageName) + '.' + "syntaxColorer";
    }

    public static String tokenTypeTag(String languageName) {
        return String.valueOf(PreferenceStoreAccessor.syntaxColorerTag(languageName)) + '.' + "tokenStyles";
    }
}

