/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Case;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchExpression
extends Expression {
    private static final List<Case> EMPTY_CASES = Collections.emptyList();
    private Expression switchExpr = null;
    private Expression defaultExpr = null;
    private List<Case> cases = null;

    public SwitchExpression(Expression switchExpr, List<Case> cases, Expression defaultExpr) {
        this.switchExpr = switchExpr;
        this.cases = cases != null && !cases.isEmpty() ? cases : EMPTY_CASES;
        this.defaultExpr = defaultExpr;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Object switchVal = Boolean.TRUE;
        if (this.switchExpr != null) {
            switchVal = this.switchExpr.evaluate(ctx);
        }
        for (Case c : this.cases) {
            Object caseCondVal = c.getCondition().evaluate(ctx);
            if (switchVal != caseCondVal && (switchVal == null || !this.equals(switchVal, caseCondVal, ctx))) continue;
            return c.getThenPart().evaluate(ctx);
        }
        return this.defaultExpr.evaluate(ctx);
    }

    private boolean equals(Object switchVal, Object caseCondVal, ExecutionContext ctx) {
        Object[] params = new Object[]{caseCondVal};
        Operation op = ctx.findOperation("==", switchVal, params);
        if (op != null) {
            return (Boolean)op.evaluate(switchVal, params);
        }
        throw new UnsupportedOperationException("'==' not found.");
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type condType = ctx.getBooleanType();
        if (this.switchExpr != null) {
            condType = this.switchExpr.analyze(ctx, issues);
        }
        if (condType == null) {
            return null;
        }
        Type returnType = this.defaultExpr.analyze(ctx, issues);
        if (returnType == null) {
            return null;
        }
        for (Case c : this.cases) {
            Type caseThenType;
            Type caseCondType = c.getCondition().analyze(ctx, issues);
            if (caseCondType != null && !condType.isAssignableFrom(caseCondType)) {
                issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, String.valueOf(condType.getName()) + " expected!", c.getCondition()));
            }
            if ((caseThenType = c.getThenPart().analyze(ctx, issues)) == null || returnType.isAssignableFrom(caseThenType)) continue;
            returnType = caseThenType.isAssignableFrom(returnType) ? caseThenType : ctx.getObjectType();
        }
        return returnType;
    }

    public List<Case> getCases() {
        return this.cases;
    }

    public Expression getDefaultExpr() {
        return this.defaultExpr;
    }

    public Expression getSwitchExpr() {
        return this.switchExpr;
    }

    @Override
    protected String toStringInternal() {
        return "switch " + this.switchExpr.toStringInternal();
    }
}

