/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.threadgroups;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaThreadGroup;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPreferenceInitializer;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaElementContentProvider;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class JavaThreadEventHandler
extends ThreadEventHandler
implements IPropertyChangeListener,
TreeListener {
    private boolean fDisplayMonitors;
    private Tree fTree;

    public JavaThreadEventHandler(AbstractModelProxy proxy) {
        super(proxy);
        IPreferenceStore preferenceStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fDisplayMonitors = preferenceStore.getBoolean(IJavaDebugUIConstants.PREF_SHOW_MONITOR_THREAD_INFO);
    }

    protected void init(Viewer viewer) {
        Control control = viewer.getControl();
        if (control instanceof Tree) {
            this.fTree = (Tree)control;
            this.fTree.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JavaThreadEventHandler.this.fTree.addTreeListener((TreeListener)JavaThreadEventHandler.this);
                }
            });
        }
    }

    public synchronized void dispose() {
        if (this.fTree != null) {
            this.fTree.removeTreeListener((TreeListener)this);
        }
        IPreferenceStore preferenceStore = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected ModelDelta addPathToThread(ModelDelta delta, IThread thread) {
        if (JavaElementContentProvider.isDisplayThreadGroups()) {
            ILaunch launch = thread.getLaunch();
            Object[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            Object[] launchChildren = launch.getChildren();
            delta = delta.addNode((Object)launch, this.indexOf(launches, launch), 0, launchChildren.length);
            IJavaDebugTarget debugTarget = (IJavaDebugTarget)thread.getDebugTarget();
            ArrayList<IJavaThreadGroup> groups = new ArrayList<IJavaThreadGroup>();
            try {
                delta = delta.addNode((Object)debugTarget, this.indexOf(launchChildren, debugTarget), 0, debugTarget.getRootThreadGroups().length);
                IJavaThread javaThread = (IJavaThread)thread;
                IJavaThreadGroup threadGroup = javaThread.getThreadGroup();
                while (threadGroup != null) {
                    groups.add(0, threadGroup);
                    threadGroup = threadGroup.getThreadGroup();
                }
                for (IJavaThreadGroup group : groups) {
                    int index = -1;
                    IJavaThreadGroup parent = group.getThreadGroup();
                    if (parent != null) {
                        index = this.indexOf(parent.getThreadGroups(), group);
                        if (index >= 0) {
                            index += parent.getThreads().length;
                        }
                    } else {
                        index = this.indexOf(debugTarget.getRootThreadGroups(), group);
                    }
                    delta = delta.addNode((Object)group, index, 0, group.getThreadGroups().length + group.getThreads().length);
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
            }
            return delta;
        }
        return super.addPathToThread(delta, thread);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IJavaDebugUIConstants.PREF_SHOW_MONITOR_THREAD_INFO)) {
            this.fDisplayMonitors = JDIDebugUIPreferenceInitializer.getBoolean(event);
        }
    }

    protected boolean isDisplayMonitors() {
        return this.fDisplayMonitors;
    }

    protected int indexOf(IStackFrame frame) {
        IThread thread;
        int index = 0;
        if (this.isDisplayMonitors()) {
            if (((IJavaDebugTarget)frame.getDebugTarget()).supportsMonitorInformation()) {
                thread = (IJavaThread)frame.getThread();
                try {
                    index = thread.getOwnedMonitors().length;
                    if (thread.getContendedMonitor() != null) {
                        ++index;
                    }
                }
                catch (DebugException debugException) {}
            } else {
                index = 1;
            }
        }
        if ((thread = frame.getThread()) instanceof IJavaThread) {
            this.waitIfEvaluationRuns((IJavaThread)thread, 1000L);
        }
        return index + super.indexOf(frame);
    }

    private void waitIfEvaluationRuns(IJavaThread thread, long maxWaitTimeMillis) {
        long start = System.currentTimeMillis();
        while (thread.isPerformingEvaluation() && !thread.isTerminated()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (System.currentTimeMillis() - start > maxWaitTimeMillis) break;
        }
    }

    protected int childCount(IThread thread) {
        try {
            IJavaThread jThread = (IJavaThread)thread;
            int count = jThread.getFrameCount();
            if (this.isDisplayMonitors()) {
                if (((IJavaDebugTarget)thread.getDebugTarget()).supportsMonitorInformation()) {
                    count += jThread.getOwnedMonitors().length;
                    if (jThread.getContendedMonitor() != null) {
                        ++count;
                    }
                } else {
                    ++count;
                }
            }
            return count;
        }
        catch (DebugException debugException) {
            return -1;
        }
    }

    protected int indexOf(IThread thread) {
        if (JavaElementContentProvider.isDisplayThreadGroups()) {
            IJavaThread javaThread = (IJavaThread)thread;
            try {
                return this.indexOf(javaThread.getThreadGroup().getThreads(), javaThread);
            }
            catch (CoreException coreException) {
                return -1;
            }
        }
        return super.indexOf(thread);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handlesEvent(DebugEvent event) {
        IJavaThread thread;
        ILaunch launch;
        if (!super.handlesEvent(event)) return false;
        Object source = event.getSource();
        if (!(source instanceof IJavaThread) || (launch = (thread = (IJavaThread)source).getLaunch()) == null || launch.getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) == null || event.getKind() != 2) return true;
        try {
            IJavaStackFrame frame = (IJavaStackFrame)thread.getTopStackFrame();
            if (frame != null && !frame.getDeclaringTypeName().startsWith("org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookMain")) return true;
            return false;
        }
        catch (DebugException debugException) {
            return true;
        }
    }

    public void treeCollapsed(TreeEvent e) {
        TreeItem item;
        Object data;
        Widget widget = e.item;
        if (widget instanceof TreeItem && (data = (item = (TreeItem)widget).getData()) instanceof IJavaThread) {
            this.removeQueuedThread((IThread)((IJavaThread)data));
        }
    }

    public void treeExpanded(TreeEvent e) {
        TreeItem item;
        Object data;
        Widget widget = e.item;
        if (widget instanceof TreeItem && (data = (item = (TreeItem)widget).getData()) instanceof IJavaThread) {
            this.queueSuspendedThread((IThread)((IJavaThread)data));
        }
    }

    void addSuspendedThread(IJavaThread thread) {
        this.queueSuspendedThread((IThread)thread);
    }

    protected void handleOther(DebugEvent event) {
        if (event.getDetail() == 501 || event.getDetail() == 500) {
            return;
        }
        super.handleOther(event);
    }

    private boolean isMissingRequiredThreadGroup(DebugEvent event) {
        Object source;
        if (JavaElementContentProvider.isDisplayThreadGroups() && (source = event.getSource()) instanceof IJavaThread) {
            IJavaThread thread = (IJavaThread)source;
            try {
                if (thread.getThreadGroup() == null) {
                    return true;
                }
            }
            catch (DebugException debugException) {
                return true;
            }
        }
        return false;
    }

    protected void handleCreate(DebugEvent event) {
        if (this.isMissingRequiredThreadGroup(event)) {
            return;
        }
        super.handleCreate(event);
    }

    protected void handleTerminate(DebugEvent event) {
        if (this.isMissingRequiredThreadGroup(event)) {
            return;
        }
        super.handleTerminate(event);
    }
}

