/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.constraints.CConstraintValue;
import org.eclipse.comma.monitoring.lib.constraints.CFormula;
import org.eclipse.comma.monitoring.lib.constraints.CSequenceElement;
import org.eclipse.comma.monitoring.lib.messages.CEnvironment;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CSequence
extends CFormula {
    protected int conditionIndex = 0;
    protected CEnvironment env;
    protected List<CSequenceElement> elements = new ArrayList<CSequenceElement>();
    protected int currentElement = 0;

    public CSequence addElement(CSequenceElement element) {
        this.elements.add(element);
        return this;
    }

    public List<CSequenceElement> getElements() {
        return this.elements;
    }

    public CSequence setEnvironment(CEnvironment env) {
        this.env = env;
        return this;
    }

    public CEnvironment getEnvironment() {
        return this.env;
    }

    public CSequence setConditionIndex(int i) {
        this.conditionIndex = i;
        return this;
    }

    @Override
    public CConstraintValue consume(CObservedMessage message) {
        CConstraintValue r = this.elements.get(this.currentElement).consume(message);
        if (r == CConstraintValue.TRUE) {
            ++this.currentElement;
            if (this.currentElement == this.elements.size()) {
                if (this.conditionIndex > 0) {
                    if (this.env.checkCondition(this.conditionIndex, message)) {
                        return CConstraintValue.TRUE;
                    }
                    return CConstraintValue.FALSE;
                }
                return CConstraintValue.TRUE;
            }
        }
        if (r == CConstraintValue.FALSE) {
            return CConstraintValue.FALSE;
        }
        return CConstraintValue.UNKNOWN;
    }
}

