/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.messages;

import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.comma.monitoring.lib.CState;
import org.eclipse.comma.monitoring.lib.messages.CEnvironment;
import org.eclipse.comma.monitoring.lib.messages.CMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.values.CVariable;

public class CMessagePattern
extends CMessage {
    protected BiFunction<CState, List<Object>, Boolean> preCondition = null;

    public CMessagePattern() {
    }

    public CMessagePattern(String name) {
        super(name);
    }

    public CMessagePattern(String name, String source, String destination, String sourcePort, String destinationPort) {
        super(name, source, destination, sourcePort, destinationPort);
    }

    public CMessagePattern setPrecondition(BiFunction<CState, List<Object>, Boolean> preCondition) {
        this.preCondition = preCondition;
        return this;
    }

    private boolean checkStates(List<String> observedStates) {
        if (!this.states.isEmpty()) {
            if (observedStates.isEmpty()) {
                return false;
            }
            return this.states.contains(observedStates.get(0));
        }
        return true;
    }

    private boolean checkOrigin(CObservedMessage observedMessage) {
        if (!this.source.equals("*") && !this.destination.equals("*")) {
            return this.sourcePort.equals(observedMessage.getSourcePort()) && this.source.equals(observedMessage.getSource()) || this.destinationPort.equals(observedMessage.getDestinationPort()) && this.destination.equals(observedMessage.getDestination());
        }
        return !(!this.sourcePort.equals("*") && !this.sourcePort.equals(observedMessage.getSourcePort()) || !this.destinationPort.equals("*") && !this.destinationPort.equals(observedMessage.getDestinationPort()) || !this.source.equals("*") && !this.source.equals(observedMessage.getSource()) || !this.destination.equals("*") && !this.destination.equals(observedMessage.getDestination()));
    }

    private boolean checkParameters(List<Object> observedParameters) {
        if (this.parameters.isEmpty()) {
            return true;
        }
        if (this.parameters.size() != observedParameters.size()) {
            return false;
        }
        int i = 0;
        while (i < this.parameters.size()) {
            if (!this.parameters.get(i).equals(observedParameters.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkPrecondition(CState observedInterfaceState, List<Object> params) {
        if (this.preCondition != null && observedInterfaceState != null) {
            return this.preCondition.apply(observedInterfaceState, params);
        }
        return true;
    }

    public boolean match(CObservedMessage observedMessage) {
        return (this.name.equals("*") || this.name.equals(observedMessage.getName())) && this.checkStates(observedMessage.getStates()) && this.checkOrigin(observedMessage) && this.checkParameters(observedMessage.getParameters()) && this.checkPrecondition(observedMessage.getInterfaceState(), observedMessage.getParameters());
    }

    public boolean match(CObservedMessage observedMessage, CEnvironment env) {
        if (this.match(observedMessage)) {
            this.bindVariables(env, observedMessage);
            return true;
        }
        return false;
    }

    public void bindVariables(CEnvironment env, CObservedMessage observedMessage) {
        int i = 0;
        while (i < this.parameters.size()) {
            if (this.parameters.get(i) instanceof CVariable) {
                env.setVariableValue(((CVariable)this.parameters.get(i)).getName(), observedMessage.getParameters().get(i));
            }
            ++i;
        }
    }
}

