/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;

public class EVariableCollection {
    private final Map<String, EVariable> variables;

    public EVariableCollection() {
        this.variables = new LinkedHashMap<String, EVariable>();
    }

    private EVariableCollection(Map<String, EVariable> variables) {
        this.variables = variables;
    }

    private void checkIfExistsThrow(String name) {
        if (!this.variables.containsKey(name)) {
            throw new RuntimeException(String.format("Variable '%s' does not exist", name));
        }
    }

    public void put(String name, EVariable variable) {
        this.checkIfExistsThrow(name);
        this.variables.put(name, variable);
    }

    public EVariable get(String name) {
        this.checkIfExistsThrow(name);
        return this.variables.get(name);
    }

    public boolean has(String name) {
        return this.variables.containsKey(name);
    }

    public EVariableCollection clone() {
        LinkedHashMap<String, EVariable> variables = new LinkedHashMap<String, EVariable>(this.variables);
        return new EVariableCollection(variables);
    }

    public void add(Variable variable) {
        this.add(variable.getName(), EVariable.fromType(variable.getType().getType()));
    }

    public void clear() {
        this.variables.clear();
    }

    public void add(String name, EVariable variable) {
        if (this.variables.containsKey(name)) {
            throw new RuntimeException(String.format("Variable '%s' already exist", name));
        }
        this.variables.put(name, variable);
    }

    public List<String> allNamesSorted() {
        ArrayList<String> names = new ArrayList<String>(this.variables.keySet());
        Collections.sort(names);
        return names;
    }

    public EVariableCollection combine(EVariableCollection otherVariables) {
        LinkedHashMap<String, EVariable> variables = new LinkedHashMap<String, EVariable>(this.variables);
        for (Map.Entry<String, EVariable> entry : otherVariables.variables.entrySet()) {
            if (variables.containsKey(entry.getKey())) {
                throw new RuntimeException("Variable name clash");
            }
            variables.put(entry.getKey(), entry.getValue());
        }
        return new EVariableCollection(variables);
    }

    public void apply(Object action, EVariableCollection allVariables) {
        if (action instanceof RecordFieldAssignmentAction) {
            RecordFieldAssignmentAction a = (RecordFieldAssignmentAction)action;
            ExpressionRecordAccess access = (ExpressionRecordAccess)a.getFieldAccess();
            String key = access.getField().getName();
            EVariable value = EVariable.fromExpression(a.getExp(), allVariables);
            EVariable record = EVariable.fromExpression(access.getRecord(), allVariables);
            LinkedHashMap<String, EVariable> newValue = new LinkedHashMap<String, EVariable>(record.getValueRecord());
            newValue.put(key, value);
            ExpressionVariable e = (ExpressionVariable)access.getRecord();
            this.put(e.getVariable().getName(), record.clone(newValue));
        } else if (action instanceof AssignmentAction) {
            AssignmentAction a = (AssignmentAction)action;
            this.put(a.getAssignment().getName(), EVariable.fromExpression(a.getExp(), allVariables));
        } else {
            throw new RuntimeException("Not supported");
        }
    }
}

