/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.handler;

import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.comma.project.ui.handler.LaunchShortcut;
import org.eclipse.comma.project.ui.handler.ProjectUIGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.util.ResourceUtil;
import org.eclipse.xtext.validation.IResourceValidator;

public class ProjectUIGeneratorAndLaunch
extends ProjectUIGenerator {
    private static final Logger LOGGER = Logger.getLogger(ProjectUIGeneratorAndLaunch.class.getName());
    private final IResource[] javaResource = new IResource[2];
    private final LaunchShortcut launch;
    final String mode;
    final LaunchFile launchFile;

    public ProjectUIGeneratorAndLaunch(IFile file, IGenerator2 generator, EclipseResourceFileSystemAccess2 fileAccessProvider, IResourceSetProvider resourceSetProvider, EclipseOutputConfigurationProvider outputConfigurationProvider, IResourceValidator validator, Shell activeShell, LaunchShortcut launchShortcut, String mode, LaunchFile launchFile) {
        super(file, generator, fileAccessProvider, resourceSetProvider, outputConfigurationProvider, validator, activeShell);
        this.mode = mode;
        this.launchFile = launchFile;
        this.launch = launchShortcut;
    }

    public IFile getMonitorJavaFile() throws FileNotFoundException {
        if (this.javaResource[0] instanceof IFile) {
            return (IFile)this.javaResource[0];
        }
        throw new FileNotFoundException(MessageFormat.format("Generated {0} was not found.", this.getMonitorFileName()));
    }

    @Override
    public void start() {
        super.start();
        try {
            switch (this.launchFile) {
                case MONITOR: {
                    this.launch.actualLaunch(this.getMonitorJavaFile(), this.mode);
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.info("Generate then launch monitoring: " + e.getMessage());
        }
    }

    @Override
    protected void refreshOutputFolders(IProject project, Map<String, OutputConfiguration> outputConfigurations, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)outputConfigurations.size());
        for (OutputConfiguration config : outputConfigurations.values()) {
            SubMonitor child = subMonitor.newChild(1);
            for (IContainer container : this.getOutputs(project, config)) {
                if (!container.exists()) continue;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ResourceUtil.sync((IResource)container, (int)2, (IProgressMonitor)child);
                this.findJavaResource(container);
            }
        }
    }

    private void findJavaResource(IContainer container) throws CoreException {
        container.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getName().equals(ProjectUIGeneratorAndLaunch.this.getMonitorFileName())) {
                    ProjectUIGeneratorAndLaunch.this.javaResource[0] = proxy.requestResource();
                }
                return true;
            }
        }, 2);
    }

    public static enum LaunchFile {
        MONITOR;

    }
}

