/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.eclipse.comma.monitoring.dashboard.DashboardHelper;
import org.eclipse.comma.monitoring.lib.CTaskResults;
import org.eclipse.comma.monitoring.lib.ExportResults;

public class ExportToDashboard
implements ExportResults {
    private static final String RESULTS_PATH = "comma-gen" + File.separator;

    @Override
    public void export(List<CTaskResults> taskResults) {
        File file = new File(String.valueOf(RESULTS_PATH) + "dashboard.html");
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        JsonElement element = gson.toJsonTree(taskResults);
        try {
            this.replaceUmlFileWithBase64(element);
            String resultsInJson = gson.toJson(element);
            String dashboardHTML = DashboardHelper.getHTML();
            dashboardHTML = dashboardHTML != null ? dashboardHTML.replace("\"%MONITORING_TASKS%\"", resultsInJson) : "Dashboard not present, likely you forgot to build Comma with the -Pdashboard flag, see developing.md";
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(dashboardHTML);
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String renderUmlFileAsBase64(String umlFile) throws IOException {
        String content = Files.readString(Paths.get(umlFile, new String[0]));
        SourceStringReader reader = new SourceStringReader(content);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.PNG));
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    private void replaceUmlFileWithBase64(Object object) throws IOException {
        block4: {
            block3: {
                if (!(object instanceof JsonArray)) break block3;
                JsonArray jsonArray = (JsonArray)object;
                int i = 0;
                while (i < jsonArray.size()) {
                    this.replaceUmlFileWithBase64(jsonArray.get(i));
                    ++i;
                }
                break block4;
            }
            if (!(object instanceof JsonObject)) break block4;
            JsonObject jsonObject = (JsonObject)object;
            for (String key : jsonObject.keySet()) {
                if (key.equals("umlFile")) {
                    String umlFile = jsonObject.get(key).getAsString();
                    String base64 = this.renderUmlFileAsBase64(umlFile);
                    jsonObject.addProperty("umlBase64", base64);
                    jsonObject.remove(key);
                    continue;
                }
                this.replaceUmlFileWithBase64(jsonObject.get(key));
            }
        }
    }
}

