/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.webapp.AbstractFrame;

public class FrameData
extends RequestData {
    private static final String FRAME_EXTENSION_POINT = "org.eclipse.help.webapp.frame";
    private List<AbstractFrame> allFrames;

    public FrameData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
    }

    public AbstractFrame[] getFrames(int location) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(FRAME_EXTENSION_POINT);
        if (this.allFrames == null) {
            this.allFrames = new ArrayList<AbstractFrame>();
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object obj = null;
                try {
                    obj = element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Platform.getLog(this.getClass()).error("Create extension failed:[org.eclipse.help.webapp.frame].", (Throwable)e);
                }
                if (obj instanceof AbstractFrame) {
                    this.allFrames.add((AbstractFrame)obj);
                }
                ++n2;
            }
            this.allFrames.sort(null);
        }
        ArrayList<AbstractFrame> frameList = new ArrayList<AbstractFrame>();
        for (AbstractFrame frame : this.allFrames) {
            if (!frame.isVisible() || frame.getLocation() != location) continue;
            frameList.add(frame);
        }
        AbstractFrame[] frames = frameList.toArray(new AbstractFrame[frameList.size()]);
        return frames;
    }

    public String getUrl(AbstractFrame frame) {
        return String.valueOf(this.request.getContextPath()) + frame.getURL();
    }

    public String getContentAreaFrameSizes() {
        AbstractFrame[] frames;
        String size = "24,*";
        AbstractFrame[] abstractFrameArray = frames = this.getFrames(1);
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFrame frame = abstractFrameArray[n2];
            size = String.valueOf(size) + ',';
            size = String.valueOf(size) + frame.getSize();
            ++n2;
        }
        return size;
    }

    public AbstractFrame getHelpToolbarFrame() {
        AbstractFrame[] frames = this.getFrames(2);
        if (frames.length > 0) {
            if (frames.length > 1) {
                Platform.getLog(this.getClass()).warn("Only one extra frame is supported to be added to Help Toolbar. The first reterived element will be used.");
            }
            return frames[0];
        }
        return null;
    }

    public String getHelpToolbarFrameSizes() {
        String size = "*";
        AbstractFrame frame = this.getHelpToolbarFrame();
        if (frame != null) {
            boolean isRTL = UrlUtil.isRTL(this.request, this.response);
            size = isRTL ? String.valueOf(frame.getSize()) + ", " + size : String.valueOf(size) + ", " + frame.getSize();
        }
        return size;
    }
}

