/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core;

import java.util.Collections;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.cdo.internal.core.Activator;

class GMFSafePackageProcessor
implements InternalCDOPackageRegistry.PackageProcessor {
    private final Object NOT_PROCESSED_TOKEN = new Object();
    private final InternalCDOPackageRegistry.PackageProcessor delegate;

    public GMFSafePackageProcessor(InternalCDOPackageRegistry.PackageProcessor processor) {
        this.delegate = processor;
    }

    public Object processPackage(Object value) {
        EPackage ePackage;
        TransactionalEditingDomain domain;
        Object result = this.NOT_PROCESSED_TOKEN;
        if (EMFUtil.isDynamicEPackage((Object)value) && (domain = TransactionUtil.getEditingDomain((EObject)(ePackage = (EPackage)value))) != null) {
            InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)domain;
            InternalTransaction transaction = null;
            try {
                transaction = internalDomain.startTransaction(false, Collections.singletonMap("unprotected", Boolean.TRUE));
                result = this.delegate.processPackage(value);
                transaction.commit();
            }
            catch (RollbackException e) {
                Activator.log.error("Failed to commit processed package.", (Throwable)e);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in processing package.", (Throwable)e);
                transaction.rollback();
            }
        }
        if (result == this.NOT_PROCESSED_TOKEN) {
            result = this.delegate.processPackage(value);
        }
        return result;
    }
}

