/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.polarsys.chess.contracts.transformations.commands.CommandsCommon;
import org.polarsys.chess.contracts.transformations.dialogs.SelectImplementationDialog;
import org.polarsys.chess.contracts.transformations.dialogs.SelectOcraAnalysisCtxDialog;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class CheckImplHandler
extends AbstractHandler {
    private static final String SYSTEM = "CHESSContract::System";
    private String systemQN;
    private String block;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String modelname;
        Shell activeShell;
        IEditorPart editorPart;
        block10: {
            block8: {
                Model model;
                block9: {
                    block7: {
                        editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                        activeShell = window.getShell();
                        modelname = "";
                        if (CHESSEditorUtils.isCHESSProject((IEditorPart)editorPart)) break block7;
                        return null;
                    }
                    PapyrusMultiDiagramEditor editor = (PapyrusMultiDiagramEditor)editorPart;
                    Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
                    model = ResourceUtils.getModel((Resource)res);
                    SelectOcraAnalysisCtxDialog sysDialog = new SelectOcraAnalysisCtxDialog(activeShell, model);
                    sysDialog.create();
                    if (sysDialog.open() != 0) break block8;
                    this.systemQN = sysDialog.getSystem();
                    if (this.systemQN != null && !this.systemQN.isEmpty()) break block9;
                    return null;
                }
                try {
                    Class sysClass = null;
                    for (Element elem : model.allOwnedElements()) {
                        if (elem.getAppliedStereotype(SYSTEM) == null || !((NamedElement)elem).getQualifiedName().equals(this.systemQN)) continue;
                        sysClass = (Class)elem;
                    }
                    if (sysClass == null) break block10;
                    SelectImplementationDialog implDialog = new SelectImplementationDialog(activeShell, sysClass);
                    if (implDialog.open() == 0) {
                        this.block = implDialog.getBlock();
                        if (this.block == null || this.block.isEmpty()) {
                            return null;
                        }
                        break block10;
                    }
                    return null;
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.systemQN);
        String systemName = this.systemQN.substring(this.systemQN.lastIndexOf("::") + 2);
        args.add(systemName);
        args.add(modelname);
        CommandsCommon.TransformationJob(activeShell, editorPart, args, CommandsCommon.CommandEnum.IMPLEMENTATION, this.block, null);
        return null;
    }
}

