/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.profiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.polarsys.chess.chessmlprofile.ComponentModel.ComponentModelPackage;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.DependableComponentPackage;
import org.polarsys.chess.chessmlprofile.Dependability.FailurePropagation.FailurePropagationPackage;
import org.polarsys.chess.chessmlprofile.Dependability.MitigationMeans.MitigationMeansPackage;
import org.polarsys.chess.chessmlprofile.Dependability.StateBased.FaultTolerance.FaultTolerancePackage;
import org.polarsys.chess.chessmlprofile.Dependability.StateBased.MaintenanceMonitoring.MaintenanceMonitoringPackage;
import org.polarsys.chess.chessmlprofile.Dependability.StateBased.StateBasedAnalysis.StateBasedAnalysisPackage;
import org.polarsys.chess.chessmlprofile.Dependability.StateBased.StateBasedComponents.StateBasedComponentsPackage;
import org.polarsys.chess.chessmlprofile.Dependability.ThreatsPropagation.ThreatsPropagationPackage;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.HardwareBaselinePackage;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.RTComponentModelPackage;
import org.polarsys.chess.chessmlprofile.SystemModel.STS.STSPackage;
import org.polarsys.chess.core.internal.extensionpoint.AddProfileHandler;
import org.polarsys.chess.core.util.uml.UMLUtils;

public class CHESSProfileManager {
    public static final String COMPONENT_VIEW = "ComponentView";
    public static final String EXTRAFUNCTIONAL_VIEW = "ExtraFunctionalView";
    public static final String DEPLOYMENT_VIEW = "DeploymentView";
    public static final String ANALYSIS_VIEW = "AnalysisView";
    public static final String DEPENDABILITY_ANALYSIS_VIEW = "DependabilityAnalysisView";
    public static final String RT_ANALYSIS_VIEW = "RTAnalysisView";
    public static final String PSM_VIEW = "PSMView";
    public static final String TIMING_DATAFLOW_VIEW = "TimingDataFlowView";
    public static final String REQUIREMENT_VIEW = "RequirementView";
    public static final String DEPENDABILITY_VIEW = "DependabilityView";
    public static final String SYSTEM_VIEW = "SystemView";
    public static final String RAILWAY_VIEW = "RailwayView";
    public static final String NULL_VIEW = "NullView";
    public static final ArrayList<String> UNUSED_VIEWS = new ArrayList();
    public static final ArrayList<String> CONCURRENT_VIEWS;
    public static final ArrayList<String> SUBVIEWS;
    public static final ArrayList<String> CONCURRENT_VIEWS_COMPONENT;
    public static final ArrayList<String> CONCURRENT_VIEWS_DEPLOYMENT;
    public static final HashMap<String, ArrayList<String>> CONCURRENT_VIEWS_ASSOCIATION;
    public static final String CHESS_PROFILE = "CHESS-ML";
    public static final String CORE_PROFILE = "Core";
    public static final String VIEWS_PROFILE = "CHESSViews";
    public static final String COMPONENTMODEL_PROFILE = "ComponentModel";
    public static final String CHESS_STRT = "CHESS";
    public static HashSet<String> CHESS_VIEWS_LIST;
    public static HashSet<String> ROOT_VIEWS;
    public static ArrayList<String> PREDEFINED_PROFILES;
    public static final String CHESSML_PATH = "pathmap://CHESSML_PROFILE/CHESS.profile.uml";
    public static boolean ARE_VIEWS_LOADED;
    private static boolean ARE_PROFILES_LOADED;

    static {
        UNUSED_VIEWS.add(TIMING_DATAFLOW_VIEW);
        CONCURRENT_VIEWS = new ArrayList();
        CONCURRENT_VIEWS.add(EXTRAFUNCTIONAL_VIEW);
        CONCURRENT_VIEWS.add(DEPENDABILITY_VIEW);
        CONCURRENT_VIEWS.add(RAILWAY_VIEW);
        SUBVIEWS = new ArrayList();
        SUBVIEWS.add(RT_ANALYSIS_VIEW);
        SUBVIEWS.add(DEPENDABILITY_ANALYSIS_VIEW);
        CONCURRENT_VIEWS_COMPONENT = new ArrayList();
        CONCURRENT_VIEWS_COMPONENT.add(EXTRAFUNCTIONAL_VIEW);
        CONCURRENT_VIEWS_COMPONENT.add(RAILWAY_VIEW);
        CONCURRENT_VIEWS_DEPLOYMENT = new ArrayList();
        CONCURRENT_VIEWS_DEPLOYMENT.add(DEPENDABILITY_VIEW);
        CONCURRENT_VIEWS_ASSOCIATION = new HashMap();
        CONCURRENT_VIEWS_ASSOCIATION.put(COMPONENT_VIEW, CONCURRENT_VIEWS_COMPONENT);
        CONCURRENT_VIEWS_ASSOCIATION.put(DEPLOYMENT_VIEW, CONCURRENT_VIEWS_DEPLOYMENT);
        CHESS_VIEWS_LIST = new HashSet();
        ROOT_VIEWS = new HashSet();
        PREDEFINED_PROFILES = new ArrayList();
        ARE_VIEWS_LOADED = false;
    }

    public static Stereotype applyCH_HwBusStereotype(Element element) {
        return UMLUtils.applyStereotype(element, "CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwBus");
    }

    public static Stereotype applyCHGaResourcePlatformStereotype(Package pack) {
        return UMLUtils.applyStereotype((Element)pack, "CHESS::Core::CHGaResourcePlatform");
    }

    public static Stereotype applyChRTPortSlotStereotype(Slot element) {
        return UMLUtils.applyStereotype((Element)element, "CHESS::Predictability::RTComponentModel::CHRtPortSlot");
    }

    public static Stereotype applyChRTPortSlotStereotype(InstanceSpecification element) {
        return UMLUtils.applyStereotype((Element)element, "CHESS::Predictability::RTComponentModel::CHRtPortSlot");
    }

    public static Stereotype applyFPTCPortSlotStereotype(Slot element) {
        return UMLUtils.applyStereotype((Element)element, "CHESS::Dependability::FailurePropagation::FPTCPortSlot");
    }

    public static Stereotype applyMultiInstanceStereotype(InstanceSpecification element) {
        return UMLUtils.applyStereotype((Element)element, "CHESS::Core::MultiInstance");
    }

    public static Stereotype applyMultiSlotStereotype(Slot element) {
        return UMLUtils.applyStereotype((Element)element, "CHESS::Core::MultSlot");
    }

    public static Stereotype applyPropagationStereotype(InstanceSpecification element) {
        return UMLUtils.applyStereotype((Element)element, "CHESS::Dependability::DependableComponent::Propagation");
    }

    public static Stereotype getCH_HWBus(Element element) {
        return UMLUtils.getStereotype(element, "CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwBus");
    }

    public static Stereotype getCH_HWComputingResource(Element element) {
        return UMLUtils.getStereotype(element, "CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwComputingResource");
    }

    public static Stereotype getCH_HWProcessor(Element element) {
        return UMLUtils.getStereotype(element, "CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwProcessor");
    }

    public static Stereotype getCHRTSpecification(Element element) {
        return UMLUtils.getStereotype(element, "CHESS::Predictability::RTComponentModel::CHRtSpecification");
    }

    public static Stereotype getFI4FASpecification(Element element) {
        Stereotype str = UMLUtils.getStereotype(element, "CHESS::Dependability::FailurePropagation::FI4FASpecification");
        return str;
    }

    public static Stereotype getFPTCSpecification(Element element) {
        return UMLUtils.getStereotype(element, "CHESS::Dependability::FailurePropagation::FPTCSpecification");
    }

    public static synchronized void initializeProfileList(Profile CHESSProfile) {
        if (!ARE_PROFILES_LOADED) {
            List pp = PackageUtil.getSubProfiles((Package)CHESSProfile);
            for (Profile profile : pp) {
                PREDEFINED_PROFILES.add(profile.getName());
            }
            ARE_PROFILES_LOADED = true;
        }
    }

    public static synchronized void initializeViewList(Profile viewsProfile) {
        if (!ARE_VIEWS_LOADED) {
            for (Stereotype str : viewsProfile.getOwnedStereotypes()) {
                CHESS_VIEWS_LIST.add(str.getName());
            }
            for (String v : CONCURRENT_VIEWS) {
                CHESS_VIEWS_LIST.add(v);
            }
            CHESS_VIEWS_LIST.add(NULL_VIEW);
            for (String v : CHESS_VIEWS_LIST) {
                if (v.equals(NULL_VIEW) || CONCURRENT_VIEWS.contains(v) || SUBVIEWS.contains(v) || UNUSED_VIEWS.contains(v)) continue;
                ROOT_VIEWS.add(v);
            }
            ARE_VIEWS_LOADED = true;
        }
    }

    public CHESSProfileManager(ResourceSet rs) {
        CHESSProfileManager.loadCHESSProfile(rs);
    }

    public static Stereotype applyCH_HwComputingResourceStereotype(Element element) {
        return UMLUtils.applyStereotype(element, "CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwComputingResource");
    }

    public static Stereotype applyCH_HwProcessorStereotype(Element element) {
        return UMLUtils.applyStereotype(element, "CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwProcessor");
    }

    public static Stereotype applyCHESSStereotype(Element element) {
        return UMLUtils.applyStereotype(element, "CHESS::Core::CHESS");
    }

    public static void applyRecursively(Model model) {
        ResourceSet rs = model.eResource().getResourceSet();
        Profile CHESSProfile = (Profile)PackageUtil.loadPackage((URI)URI.createURI((String)CHESSML_PATH), (ResourceSet)rs);
        PackageUtil.applyProfile((Package)model, (Profile)CHESSProfile, (boolean)true);
    }

    public static Stereotype applyViewStereotype(String viewName, Element element) {
        return UMLUtils.applyStereotype(element, "CHESS::Core::CHESSViews::" + viewName);
    }

    public static Stereotype getViewStereotype(Element element, String viewName) {
        return UMLUtils.getStereotype(element, "CHESS::Core::CHESSViews::" + viewName);
    }

    @Deprecated
    public static String viewName(Model model, String name) {
        return String.valueOf(model.getName()) + name;
    }

    public static void createViews(Model model) {
        Stereotype chessStereotype = model.getAppliedStereotype("CHESS::Core::CHESS");
        Package newpkg = null;
        String view = "";
        try {
            Profile stateBasedComponentProfile = UMLResourcesUtil.getProfile((EPackage)StateBasedComponentsPackage.eINSTANCE, (EObject)model);
            Profile stateBased_FaultToleranceProfile = UMLResourcesUtil.getProfile((EPackage)FaultTolerancePackage.eINSTANCE, (EObject)model);
            Profile stateBased_MaintainanceMonitoringProfile = UMLResourcesUtil.getProfile((EPackage)MaintenanceMonitoringPackage.eINSTANCE, (EObject)model);
            Profile failurePropProfile = UMLResourcesUtil.getProfile((EPackage)FailurePropagationPackage.eINSTANCE, (EObject)model);
            Profile threatsPropagationProfile = UMLResourcesUtil.getProfile((EPackage)ThreatsPropagationPackage.eINSTANCE, (EObject)model);
            Profile dependableComponentProfile = UMLResourcesUtil.getProfile((EPackage)DependableComponentPackage.eINSTANCE, (EObject)model);
            Profile mitigationProfile = UMLResourcesUtil.getProfile((EPackage)MitigationMeansPackage.eINSTANCE, (EObject)model);
            Profile componentModelProfile = UMLResourcesUtil.getProfile((EPackage)ComponentModelPackage.eINSTANCE, (EObject)model);
            Profile RTComponentModelProfile = UMLResourcesUtil.getProfile((EPackage)RTComponentModelPackage.eINSTANCE, (EObject)model);
            Profile deploymentConfiguration_HardwareBaselineProfile = UMLResourcesUtil.getProfile((EPackage)HardwareBaselinePackage.eINSTANCE, (EObject)model);
            Profile stateBased_AnalysisProfile = UMLResourcesUtil.getProfile((EPackage)StateBasedAnalysisPackage.eINSTANCE, (EObject)model);
            Profile STSProfile = UMLResourcesUtil.getProfile((EPackage)STSPackage.eINSTANCE, (EObject)model);
            view = REQUIREMENT_VIEW;
            newpkg = model.createNestedPackage(CHESSProfileManager.viewName(model, view));
            Stereotype viewStrt = CHESSProfileManager.applyViewStereotype(view, (Element)newpkg);
            model.setValue(chessStereotype, "requirementView", (Object)newpkg.getStereotypeApplication(viewStrt));
            view = SYSTEM_VIEW;
            newpkg = model.createNestedPackage(CHESSProfileManager.viewName(model, view));
            viewStrt = CHESSProfileManager.applyViewStereotype(view, (Element)newpkg);
            model.setValue(chessStereotype, "systemView", (Object)newpkg.getStereotypeApplication(viewStrt));
            newpkg.applyProfile(stateBasedComponentProfile);
            newpkg.applyProfile(stateBased_FaultToleranceProfile);
            newpkg.applyProfile(stateBased_MaintainanceMonitoringProfile);
            newpkg.applyProfile(failurePropProfile);
            newpkg.applyProfile(threatsPropagationProfile);
            newpkg.applyProfile(dependableComponentProfile);
            newpkg.applyProfile(mitigationProfile);
            newpkg.applyProfile(STSProfile);
            view = COMPONENT_VIEW;
            newpkg = model.createNestedPackage(CHESSProfileManager.viewName(model, view));
            viewStrt = CHESSProfileManager.applyViewStereotype(view, (Element)newpkg);
            model.setValue(chessStereotype, "componentView", (Object)newpkg.getStereotypeApplication(viewStrt));
            newpkg.applyProfile(componentModelProfile);
            newpkg.applyProfile(RTComponentModelProfile);
            newpkg.applyProfile(stateBasedComponentProfile);
            newpkg.applyProfile(stateBased_FaultToleranceProfile);
            newpkg.applyProfile(stateBased_MaintainanceMonitoringProfile);
            newpkg.applyProfile(failurePropProfile);
            newpkg.applyProfile(threatsPropagationProfile);
            newpkg.applyProfile(dependableComponentProfile);
            newpkg.applyProfile(mitigationProfile);
            view = DEPLOYMENT_VIEW;
            newpkg = model.createNestedPackage(CHESSProfileManager.viewName(model, view));
            viewStrt = CHESSProfileManager.applyViewStereotype(view, (Element)newpkg);
            model.setValue(chessStereotype, "deploymentView", (Object)newpkg.getStereotypeApplication(viewStrt));
            newpkg.applyProfile(deploymentConfiguration_HardwareBaselineProfile);
            newpkg.applyProfile(RTComponentModelProfile);
            newpkg.applyProfile(stateBasedComponentProfile);
            newpkg.applyProfile(stateBased_FaultToleranceProfile);
            newpkg.applyProfile(stateBased_MaintainanceMonitoringProfile);
            newpkg.applyProfile(failurePropProfile);
            newpkg.applyProfile(threatsPropagationProfile);
            newpkg.applyProfile(dependableComponentProfile);
            view = ANALYSIS_VIEW;
            newpkg = model.createNestedPackage(CHESSProfileManager.viewName(model, view));
            viewStrt = CHESSProfileManager.applyViewStereotype(view, (Element)newpkg);
            model.setValue(chessStereotype, "analysisView", (Object)newpkg.getStereotypeApplication(viewStrt));
            Stereotype innerView = CHESSProfileManager.getViewStereotype((Element)newpkg, DEPENDABILITY_ANALYSIS_VIEW);
            Package innerpkg = newpkg.createNestedPackage(String.valueOf(model.getName()) + innerView.getName());
            innerpkg.applyProfile(stateBased_AnalysisProfile);
            innerpkg.applyProfile(failurePropProfile);
            CHESSProfileManager.applyViewStereotype(DEPENDABILITY_ANALYSIS_VIEW, (Element)innerpkg);
            newpkg.setValue(viewStrt, "depanalysisview", (Object)innerpkg.getStereotypeApplication(innerView));
            innerView = CHESSProfileManager.getViewStereotype((Element)newpkg, RT_ANALYSIS_VIEW);
            Package innerpkgRT = newpkg.createNestedPackage(String.valueOf(model.getName()) + innerView.getName());
            CHESSProfileManager.applyViewStereotype(RT_ANALYSIS_VIEW, (Element)innerpkgRT);
            newpkg.setValue(viewStrt, "rtanalysisview", (Object)innerpkgRT.getStereotypeApplication(innerView));
            view = PSM_VIEW;
            newpkg = model.createNestedPackage(CHESSProfileManager.viewName(model, view));
            viewStrt = CHESSProfileManager.applyViewStereotype(view, (Element)newpkg);
            model.setValue(chessStereotype, "psmView", (Object)newpkg.getStereotypeApplication(viewStrt));
        }
        catch (Exception e) {
            System.out.println("stereotype application error: " + view + e.getMessage());
        }
    }

    public static Stereotype getComponentImplementation(Element element) {
        return UMLUtils.getStereotype(element, "CHESS::ComponentModel::ComponentImplementation");
    }

    public static Stereotype getComponentType(Element element) {
        return UMLUtils.getStereotype(element, "CHESS::ComponentModel::ComponentType");
    }

    public static void loadExternalProfiles(ResourceSet rs) {
        AddProfileHandler h = new AddProfileHandler();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        h.executeLoadProfile(reg, rs);
    }

    public static void loadCHESSProfile(ResourceSet rs) {
        CHESSProfileManager.loadCHESSViewsList(rs);
    }

    private static void loadCHESSViewsList(ResourceSet rs) {
        Profile CHESSProfile = (Profile)PackageUtil.loadPackage((URI)URI.createURI((String)CHESSML_PATH), (ResourceSet)rs);
        Profile coreProfile = (Profile)CHESSProfile.getNestedPackage(CORE_PROFILE);
        Profile viewsProfile = (Profile)coreProfile.getNestedPackage(VIEWS_PROFILE);
        CHESSProfileManager.initializeProfileList(CHESSProfile);
        CHESSProfileManager.initializeViewList(viewsProfile);
    }

    private <T extends EObject> void setViewValue(Model model, Stereotype chessStereotype, Package newpkg, Class<T> viewClass) {
        T c = UMLUtils.getStereotypeApplication((Element)newpkg, viewClass);
        Property ef = null;
        for (Property f : chessStereotype.getAllAttributes()) {
            if (!f.getName().equalsIgnoreCase(c.eClass().getName())) continue;
            ef = f;
            break;
        }
        if (ef != null) {
            model.setValue(chessStereotype, ef.getName(), c);
        }
    }

    public static void createModel(Model currentModel) {
        CHESSProfileManager.applyRecursively(currentModel);
        CHESSProfileManager.applyCHESSStereotype((Element)currentModel);
        CHESSProfileManager.createViews(currentModel);
    }

    @Deprecated
    public static Package getView(Model model, String view) {
        return model.getNestedPackage(CHESSProfileManager.viewName(model, view));
    }

    public static Package getViewByStereotype(Model model, String view) {
        EList packages = model.getNestedPackages();
        for (Package package_ : packages) {
            Stereotype x = package_.getAppliedStereotype("CHESS::Core::CHESSViews::" + view);
            if (x == null) continue;
            return package_;
        }
        return null;
    }
}

