/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.elk.core.util.IElkProgressMonitor;

final class Execution {
    private String name;
    private double executionTimeIncludingChildren;
    private double executionTimeLocal;
    private Execution parent;
    private List<Execution> children;

    private Execution() {
    }

    public static Execution fromProgressMonitor(IElkProgressMonitor monitor) {
        Execution execution = new Execution();
        execution.name = monitor.getTaskName() != null ? monitor.getTaskName() : "Unnamed";
        execution.executionTimeIncludingChildren = monitor.getExecutionTime();
        execution.parent = null;
        execution.executionTimeLocal = execution.executionTimeIncludingChildren;
        ArrayList<Execution> childExecutions = new ArrayList<Execution>(monitor.getSubMonitors().size());
        for (IElkProgressMonitor child : monitor.getSubMonitors()) {
            childExecutions.add(Execution.fromProgressMonitor(child, execution));
            execution.executionTimeLocal -= child.getExecutionTime();
        }
        execution.children = Collections.unmodifiableList(childExecutions);
        execution.executionTimeLocal = Math.max(execution.executionTimeLocal, 0.0);
        return execution;
    }

    private static Execution fromProgressMonitor(IElkProgressMonitor monitor, Execution parent) {
        Execution execution = Execution.fromProgressMonitor(monitor);
        execution.parent = parent;
        return execution;
    }

    public String getName() {
        return this.name;
    }

    public double getExecutionTimeIncludingChildren() {
        return this.executionTimeIncludingChildren;
    }

    public double getExecutionTimeLocal() {
        return this.executionTimeLocal;
    }

    public Execution getParent() {
        return this.parent;
    }

    public List<Execution> getChildren() {
        return this.children;
    }
}

