/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.papyrus.infra.properties.internal.InfraPropertiesPlugin;
import org.eclipse.papyrus.infra.properties.spi.IPropertiesResolver;

public class PropertiesURIHandler
implements URIHandler {
    public static final String ENVIRONMENT_SEGMENT = "environment";
    public static final String CONTEXT_SEGMENT = "context";
    public static final String PROPERTIES_SCHEME = "ppe";

    public boolean canHandle(URI uri) {
        return uri != null && PROPERTIES_SCHEME.equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.getConvertedURI(uri);
        if (convertedURI == null) {
            throw new IOException(String.valueOf(uri.toString()) + " not found");
        }
        URIHandler handler = this.getDelegateHandler(convertedURI);
        return handler.createInputStream(convertedURI, options);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.getConvertedURI(uri);
        URIHandler handler = this.getDelegateHandler(convertedURI);
        return handler.createOutputStream(convertedURI, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.getConvertedURI(uri);
        URIHandler handler = this.getDelegateHandler(convertedURI);
        handler.delete(convertedURI, options);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        URI convertedURI = this.getConvertedURI(uri);
        URIHandler handler = this.getDelegateHandler(convertedURI);
        return handler.contentDescription(convertedURI, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        URI convertedURI = this.getConvertedURI(uri);
        URIHandler handler = this.getDelegateHandler(convertedURI);
        return handler.exists(convertedURI, options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        URI convertedURI = this.getConvertedURI(uri);
        URIHandler handler = this.getDelegateHandler(convertedURI);
        return handler.getAttributes(convertedURI, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        URI convertedURI = this.getConvertedURI(uri);
        URIHandler handler = this.getDelegateHandler(convertedURI);
        handler.setAttributes(convertedURI, attributes, options);
    }

    protected URIHandler getDelegateHandler(URI convertedURI) {
        if (convertedURI == null) {
            return null;
        }
        for (URIHandler handler : URIHandler.DEFAULT_HANDLERS) {
            if (!handler.canHandle(convertedURI)) continue;
            return handler;
        }
        return null;
    }

    public URI getConvertedURI(URI sourceURI) {
        String segment;
        int i;
        if (sourceURI == null) {
            throw new IllegalArgumentException("sourceURI shall not be null");
        }
        String firstSegment = sourceURI.segment(0);
        URI targetURI = URI.createURI((String)"");
        if (firstSegment.equals(ENVIRONMENT_SEGMENT)) {
            i = 1;
            while (i < sourceURI.segmentsList().size()) {
                segment = (String)sourceURI.segmentsList().get(i);
                targetURI = targetURI.appendSegment(segment);
                ++i;
            }
        } else if (firstSegment.equals(CONTEXT_SEGMENT)) {
            i = 1;
            while (i < sourceURI.segmentsList().size()) {
                segment = (String)sourceURI.segmentsList().get(i);
                targetURI = targetURI.appendSegment(segment);
                ++i;
            }
        } else {
            throw new IllegalArgumentException(sourceURI + " is not a valid URI");
        }
        URI result = targetURI.resolve(URI.createURI((String)"platform:/plugin/"));
        if (!this.exists(result) && !this.exists(result = targetURI.resolve(URI.createURI((String)"platform:/resource/")))) {
            result = null;
            for (IPropertiesResolver resolver : InfraPropertiesPlugin.getInstance().getPropertyResolvers()) {
                result = resolver.resolve(targetURI);
                if (this.exists(result)) break;
                result = null;
            }
        }
        return result;
    }

    private boolean exists(URI uri) {
        for (URIHandler handler : DEFAULT_HANDLERS) {
            if (!handler.canHandle(uri)) continue;
            return handler.exists(uri, Collections.EMPTY_MAP);
        }
        return false;
    }
}

