/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.OSSImporter.core.utils;

import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.core.utils.OSSModelUtil;
import eu.fbk.tools.editor.basetype.baseType.BooleanType;
import eu.fbk.tools.editor.basetype.baseType.BoundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.ContinuousType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.EventType;
import eu.fbk.tools.editor.basetype.baseType.FixedSizeArrayType;
import eu.fbk.tools.editor.basetype.baseType.IntegerType;
import eu.fbk.tools.editor.basetype.baseType.RangeType;
import eu.fbk.tools.editor.basetype.baseType.RealType;
import eu.fbk.tools.editor.basetype.baseType.SignedWordType;
import eu.fbk.tools.editor.basetype.baseType.SimpleType;
import eu.fbk.tools.editor.basetype.baseType.UnboundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.UnsignedWordType;
import eu.fbk.tools.editor.basetype.baseType.WordArrayType;
import eu.fbk.tools.editor.basetype.baseType.WordType;
import eu.fbk.tools.editor.oss.oss.ComplexType;
import eu.fbk.tools.editor.oss.oss.ParameterizedArrayType;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.polarsys.chess.OSSImporter.core.utils.StereotypeUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public class OssTypeTranslator {
    private static final Logger logger = Logger.getLogger(OssTypeTranslator.class);
    private final EntityUtil entityUtil = EntityUtil.getInstance();
    private OSSModelUtil ossModelUtil = OSSModelUtil.getInstance();
    private final StereotypeUtil stereotypeUtil = StereotypeUtil.getInstance();
    private static OssTypeTranslator ossTypeTranslatorInstance;

    public static OssTypeTranslator getInstance() {
        if (ossTypeTranslatorInstance == null) {
            ossTypeTranslatorInstance = new OssTypeTranslator();
        }
        return ossTypeTranslatorInstance;
    }

    public Type getOrCreateTypeFromOssComplexType(ComplexType dslType, Package pkg) {
        EObject type = dslType.getComplexType();
        if (type instanceof SimpleType) {
            return this.getOrCreateTypeFromOssSimpleType((SimpleType)type, pkg);
        }
        if (type instanceof ParameterizedArrayType) {
            return this.getOrCreateTypeFromOssSimpleType(((ParameterizedArrayType)type).getType(), pkg);
        }
        return null;
    }

    public Type getOrCreateTypeFromOssSimpleType(SimpleType dslType, Package pkg) {
        if (dslType instanceof BooleanType) {
            logger.debug((Object)"BooleanType");
            return this.entityUtil.getPrimitiveType("Boolean");
        }
        if (dslType instanceof IntegerType) {
            logger.debug((Object)"IntegerType");
            return this.entityUtil.getPrimitiveType("Integer");
        }
        if (dslType instanceof RealType) {
            logger.debug((Object)"RealType");
            return this.entityUtil.getPrimitiveType("Real");
        }
        if (dslType instanceof WordType) {
            logger.debug((Object)"WordType");
        } else if (dslType instanceof UnsignedWordType) {
            logger.debug((Object)"UnsignedWordType");
        } else if (dslType instanceof SignedWordType) {
            logger.debug((Object)"SignedWordType");
        } else {
            if (dslType instanceof ContinuousType) {
                logger.debug((Object)"ContinuousType");
                return this.entityUtil.getContinuousType();
            }
            if (dslType instanceof EventType) {
                logger.debug((Object)"EventType");
                return this.entityUtil.getOrCreateSignalType(pkg);
            }
            if (dslType instanceof RangeType) {
                logger.debug((Object)"RangeType");
                return this.entityUtil.getOrCreateBoundedSubType(this.ossModelUtil.getBoundariesFromOssRangeType((RangeType)dslType), pkg, this.stereotypeUtil.boundedTypeStereotype);
            }
            if (dslType instanceof EnumType) {
                logger.debug((Object)"EnumType");
                return this.entityUtil.getOrCreateEnumerationType(this.ossModelUtil.getListValuesForEnumType((EnumType)dslType), pkg);
            }
            if (dslType instanceof FixedSizeArrayType) {
                logger.debug((Object)"FixedSizeArrayType");
                return this.getOrCreateTypeFromOssSimpleType(((FixedSizeArrayType)dslType).getType(), pkg);
            }
            if (dslType instanceof BoundedArrayType) {
                logger.debug((Object)"BoundedArrayType");
                return this.getOrCreateTypeFromOssSimpleType(((BoundedArrayType)dslType).getType(), pkg);
            }
            if (dslType instanceof UnboundedArrayType) {
                logger.debug((Object)"UnboundedArrayType");
                return this.getOrCreateTypeFromOssSimpleType(((UnboundedArrayType)dslType).getType(), pkg);
            }
            if (dslType instanceof WordArrayType) {
                logger.debug((Object)"WordArrayType");
            }
        }
        logger.error((Object)"Not able to map the requested DSL type!");
        return null;
    }

    public EList<Type> getOrCreateTypesFromOssSimpleTypes(EList<SimpleType> parameters, Package nearestPackage) {
        BasicEList types = new BasicEList();
        for (SimpleType parameterType : parameters) {
            types.add((Object)this.getOrCreateTypeFromOssSimpleType(parameterType, nearestPackage));
        }
        return types;
    }

    public EList<Type> getOrCreateTypesFromOssComplexTypes(EList<ComplexType> parameters, Package nearestPackage) {
        BasicEList types = new BasicEList();
        for (ComplexType parameterType : parameters) {
            types.add((Object)this.getOrCreateTypeFromOssComplexType(parameterType, nearestPackage));
        }
        return types;
    }
}

