/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.infra.newchild.Activator;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.ElementCreationMenuModelPackage;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Folder;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Menu;
import org.eclipse.papyrus.infra.newchild.messages.Messages;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CreationMenuRegistry {
    private static final boolean DEFAULT_VISIBILITY = true;
    protected static CreationMenuRegistry creationMenuRegistry;
    private final String MENU_CREATION_MODEL_EXTENSION_ID = "org.eclipse.papyrus.infra.newchild";
    private final String MODEL_ID = "model";
    private final String ID = "id";
    private Preferences preferences;
    private List<Folder> folders = new ArrayList<Folder>();
    private Map<String, Boolean> defaultValues = new HashMap<String, Boolean>();
    private static ResourceSetImpl resourceSet;

    public static synchronized CreationMenuRegistry getInstance() {
        if (creationMenuRegistry == null) {
            creationMenuRegistry = new CreationMenuRegistry();
            creationMenuRegistry.init();
        }
        return creationMenuRegistry;
    }

    public void init() {
        resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)ElementCreationMenuModelPackage.eINSTANCE.getNsURI(), (Object)ElementCreationMenuModelPackage.eINSTANCE);
        this.preferences = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.newchild");
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.newchild");
        int i = 0;
        while (i < configElements.length) {
            this.initializeOneModel(configElements[i]);
            ++i;
        }
    }

    public List<Folder> getRootFolder() {
        return this.folders;
    }

    public String getFolderKey(Folder folder) {
        return EcoreUtil.getURI((EObject)folder).trimFragment().toPlatformString(true);
    }

    private Folder initializeOneModel(IConfigurationElement element) {
        Folder folder = null;
        try {
            folder = this.createExtension(element, element.getAttribute("model"));
        }
        catch (Exception e) {
            Activator.log.error(Messages.CreationMenuRegistry_Error_ModelCanBeLoaded, (Throwable)e);
        }
        return folder;
    }

    public void loadCreationMenuModel(URI uri) throws Exception {
        this.unloadCreationMenuModel(uri);
        try {
            Folder folder = this.getCreationMenuModel(uri);
            this.folders.add(folder);
            this.defaultValues.put(this.getFolderKey(folder), folder.isVisible());
            folder.setVisible(this.getPreferedVisibility(folder, true));
        }
        catch (URISyntaxException e) {
            throw new Exception(String.valueOf(Messages.CreationMenuRegistry_Error_UnableToLoadCreationMenu) + e);
        }
    }

    public void unloadCreationMenuModel(URI uri) throws Exception {
        EObject folder = (EObject)resourceSet.getResource(uri, true).getContents().get(0);
        this.folders.remove(folder);
        String folderKey = this.getFolderKey((Folder)folder);
        this.defaultValues.remove(folderKey);
        this.preferences.remove(folderKey);
    }

    private Folder createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        Folder folder = null;
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            URL url = extensionBundle.getResource(classAttribute);
            if (url != null) {
                URI uri = URI.createPlatformPluginURI((String)(String.valueOf(element.getContributor().getName()) + File.separator + classAttribute), (boolean)true);
                folder = this.getCreationMenuModel(uri);
                this.defaultValues.put(this.getFolderKey(folder), folder.isVisible());
                String visible = this.preferences.get(uri.toPlatformString(true), String.valueOf(true));
                folder.setVisible(Boolean.valueOf(visible));
                this.folders.add(folder);
            }
        }
        catch (URISyntaxException e) {
            throw new Exception(String.valueOf(Messages.CreationMenuRegistry_Error_UnableToCreateExtension) + e);
        }
        return folder;
    }

    private Folder getCreationMenuModel(URI uri) throws URISyntaxException {
        Folder folder = null;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.getResource(uri, true);
        if (resource.getContents() != null && resource.getContents().size() > 0 && resource.getContents().get(0) instanceof Folder) {
            folder = (Folder)resource.getContents().get(0);
        }
        return folder;
    }

    public void setCreationMenuVisibility(URI uri, Boolean visibility) {
        this.preferences.put(uri.toPlatformString(true), String.valueOf(visibility));
        EObject eObject = resourceSet.getEObject(uri, true);
        if (eObject instanceof Folder) {
            ((Menu)eObject).setVisible(visibility);
        }
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void setCreationMenuVisibility(Folder folder, Boolean visibility) {
        this.setCreationMenuVisibility(EcoreUtil.getURI((EObject)folder), visibility);
    }

    public boolean getCreationMenuVisibility(Folder folder) {
        String visible = this.preferences.get(this.getFolderKey(folder), "");
        return "" == visible ? folder.isVisible() : Boolean.valueOf(visible).booleanValue();
    }

    public boolean getCreationMenuVisibility(URI uri) {
        Folder folder = null;
        try {
            folder = this.getCreationMenuModel(uri);
        }
        catch (URISyntaxException e) {
            Activator.log.error((Throwable)e);
        }
        String visible = this.preferences.get(uri.toPlatformString(true), "");
        return "" == visible ? folder.isVisible() : Boolean.valueOf(visible).booleanValue();
    }

    public boolean getDefaultCreationMenuVisibility(Folder folder) {
        Boolean defaultVisibility = this.defaultValues.get(this.getFolderKey(folder));
        return defaultVisibility != null ? defaultVisibility.booleanValue() : folder.isVisible();
    }

    public boolean getDefaultCreationMenuVisibility(URI uri) {
        Folder folder = null;
        try {
            folder = this.getCreationMenuModel(uri);
        }
        catch (URISyntaxException e) {
            Activator.log.error((Throwable)e);
        }
        return this.getDefaultCreationMenuVisibility(folder);
    }

    public boolean getPreferedVisibility(Folder folder, boolean defautVisibility) {
        String visible = this.preferences.get(this.getFolderKey(folder), String.valueOf(defautVisibility));
        return Boolean.valueOf(visible);
    }

    public boolean getPreferedVisibility(URI uri, boolean defautVisibility) {
        String visible = this.preferences.get(uri.toPlatformString(true), String.valueOf(defautVisibility));
        return Boolean.valueOf(visible);
    }

    public void restoreDefault() {
        try {
            this.preferences.clear();
        }
        catch (BackingStoreException e) {
            Activator.log.error((Throwable)e);
        }
        for (Folder folder : this.folders) {
            folder.setVisible(this.getDefaultCreationMenuVisibility(folder));
        }
    }
}

