/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HLAM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CallConcurrencyKind implements Enumerator
{
    SEQUENTIAL(0, "sequential", "sequential"),
    GUARDED(1, "guarded", "guarded"),
    CONCURRENT(2, "concurrent", "concurrent");

    public static final int SEQUENTIAL_VALUE = 0;
    public static final int GUARDED_VALUE = 1;
    public static final int CONCURRENT_VALUE = 2;
    private static final CallConcurrencyKind[] VALUES_ARRAY;
    public static final List<CallConcurrencyKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CallConcurrencyKind[]{SEQUENTIAL, GUARDED, CONCURRENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CallConcurrencyKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CallConcurrencyKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CallConcurrencyKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CallConcurrencyKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CallConcurrencyKind get(int value) {
        switch (value) {
            case 0: {
                return SEQUENTIAL;
            }
            case 1: {
                return GUARDED;
            }
            case 2: {
                return CONCURRENT;
            }
        }
        return null;
    }

    private CallConcurrencyKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

