/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.importt.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImportHandler
extends AbstractCommandHandler {
    static List<IFile> computeAffectedFiles(Collection<?> selected) {
        LinkedHashSet<IFile> unique = new LinkedHashSet<IFile>();
        for (Object next : selected) {
            IFile file;
            Resource resource;
            EObject object = next instanceof EObject ? (EObject)next : null;
            Resource resource2 = resource = object == null ? null : object.eResource();
            if (resource == null || (file = WorkspaceSynchronizer.getFile((Resource)resource)) == null) continue;
            unique.add(file);
        }
        return new ArrayList<IFile>(unique);
    }

    protected Command getCommand() {
        ICommand command = this.getGMFCommand();
        GMFtoEMFCommandWrapper result = new GMFtoEMFCommandWrapper(command);
        if (command instanceof AbstractImportCommand) {
            result.setDescription(((AbstractImportCommand)command).getDescription());
        }
        return result;
    }

    protected abstract ICommand getGMFCommand();

    protected void handleLoadPackage(Package _package) {
        EMFHelper.reloadIntoContext((EObject)_package, (EObject)this.getSelectedElement());
    }

    protected void handleImportPackage(Package _package) {
        PackageImport ei = UMLFactory.eINSTANCE.createPackageImport();
        Package importedPackage = (Package)EMFHelper.reloadIntoContext((EObject)_package, (EObject)this.getSelectedElement());
        ((Package)this.getSelectedElement()).getPackageImports().add((Object)ei);
        ei.setImportedPackage(importedPackage);
    }

    protected void handleCopyPackage(Package _package) {
        ((Package)this.getSelectedElement()).getNestedPackages().add((Object)((Package)EcoreUtil.copy((EObject)_package)));
    }

    protected abstract class AbstractImportCommand
    extends AbstractTransactionalCommand {
        private final Runnable runnable;
        private final String description;

        protected AbstractImportCommand(Runnable runnable, String label, String description) {
            super(AbstractImportHandler.this.getEditingDomain(), label, AbstractImportHandler.computeAffectedFiles(AbstractImportHandler.this.getSelectedElements()));
            this.runnable = runnable;
            this.description = description;
        }

        public boolean canExecute() {
            if (AbstractImportHandler.this.getSelectedElements().size() == 1) {
                return AbstractImportHandler.this.getSelectedElement() instanceof Package;
            }
            return false;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.runnable.run();
            return CommandResult.newOKCommandResult();
        }

        String getDescription() {
            return this.description;
        }
    }
}

