/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.monitoring.monitoringxml.popup.actions;

import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.polarsys.chess.monitoring.monitoringxml.popup.actions.LaunchBackpropagation;
import org.polarsys.chess.monitoring.monitoringxml.popup.actions.LaunchTraceAnalysis;

public class ImportLogHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelectionService selectionService = window.getSelectionService();
        ISelection selectionX = selectionService.getSelection();
        if (!(selectionX instanceof ITreeSelection)) {
            return null;
        }
        ITreeSelection treesel = (ITreeSelection)selectionX;
        if (treesel.getPaths().length == 0 || treesel.getPaths().length > 1) {
            return null;
        }
        Object obj = treesel.getFirstElement();
        if (!(obj instanceof EObjectTreeElement)) {
            return null;
        }
        EObject eobj = ((EObjectTreeElement)obj).getEObject();
        Class umlClass = (Class)eobj;
        umlClass.eResource().getResourceSet();
        IWorkbenchPage activePage = window.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor != null) {
            IFile monitorinFile;
            IResource resource;
            IEditorInput input = activeEditor.getEditorInput();
            IProject project = (IProject)input.getAdapter(IProject.class);
            if (project == null && (resource = (IResource)input.getAdapter(IResource.class)) != null) {
                project = resource.getProject();
            }
            if ((monitorinFile = project.getFile("\\src-gen_model\\monitoring.xml")).exists()) {
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileDialog dialog = new FileDialog(activeShell, 4096);
                dialog.setFilterExtensions(new String[]{""});
                String logPath = dialog.open();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                URI logURI = URIUtil.toURI((String)logPath);
                IFile[] logfiles = root.findFilesForLocationURI(logURI);
                LaunchTraceAnalysis traceAnalysis = new LaunchTraceAnalysis(activeShell, logfiles[0], null, monitorinFile, false);
                traceAnalysis.run(null);
                IFile analyzedTraceFile = project.getFile("\\src-gen_model\\" + umlClass.getName() + "_monitoring.xml");
                IFile umlFile = project.getFile(umlClass.eResource().getURI().lastSegment());
                if (umlFile.exists() && analyzedTraceFile.exists()) {
                    LaunchBackpropagation back = new LaunchBackpropagation(activeShell, analyzedTraceFile, umlFile, null);
                    back.run(null);
                }
            }
        }
        return null;
    }
}

