/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console.actions;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.debug.vm.ui.launching.LaunchingUtils;
import org.eclipse.ocl.examples.xtext.console.OCLConsolePage;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.ui.model.BaseDocument;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.Bundle;

public final class DebugAction
extends Action {
    protected final @NonNull OCLConsolePage oclConsolePage;

    public DebugAction(@NonNull OCLConsolePage oclConsolePage) {
        super(ConsoleMessages.Debug_Title, ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)XtextConsolePlugin.getInstance().getBundle(), (IPath)new Path("$nl$/icons/elcl16/debug.gif"), null)));
        this.oclConsolePage = oclConsolePage;
        this.setToolTipText(ConsoleMessages.Debug_ToolTip);
    }

    public ILaunch launch() {
        Shell shell;
        Control control = this.oclConsolePage.getControl();
        Shell shell2 = shell = control != null ? control.getShell() : null;
        if (shell == null) {
            MessageDialog.openError((Shell)shell, (String)ConsoleMessages.Debug_Starter, (String)ConsoleMessages.Debug_FailStart_NoShell);
            return null;
        }
        EObject contextObject = this.oclConsolePage.getContextObject();
        BaseDocument editorDocument = this.oclConsolePage.getEditorDocument();
        String text = editorDocument.get();
        String expression = text.trim();
        if (expression.length() <= 0) {
            MessageDialog.openError((Shell)shell, (String)ConsoleMessages.Debug_Starter, (String)ConsoleMessages.Debug_FailStart_NoOCL);
            return null;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        EnvironmentFactory environmentFactory = this.oclConsolePage.getEnvironmentFactory(contextObject);
        DebugStarter runnable = new DebugStarter(shell, environmentFactory, contextObject, expression);
        try {
            progressService.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            Status status = new Status(4, "org.eclipse.ocl.examples.xtext.console", targetException.getLocalizedMessage(), targetException);
            ErrorDialog.openError((Shell)shell, (String)ConsoleMessages.Debug_Starter, (String)ConsoleMessages.Debug_FailStart, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return runnable.getLaunch();
    }

    public void run() {
        this.launch();
    }

    protected static class DebugStarter
    implements IRunnableWithProgress {
        protected final @NonNull Shell shell;
        protected final @NonNull EnvironmentFactoryInternal environmentFactory;
        protected final @Nullable EObject contextObject;
        protected final @NonNull String expression;
        private @Nullable ILaunch launch = null;

        public DebugStarter(@NonNull Shell shell, @NonNull EnvironmentFactory environmentFactory, @Nullable EObject contextObject, @NonNull String expression) {
            this.shell = shell;
            this.environmentFactory = (EnvironmentFactoryInternal)environmentFactory;
            this.contextObject = contextObject;
            this.expression = expression;
        }

        protected @NonNull URI createDocument(IProgressMonitor monitor) throws IOException, CoreException {
            IdResolver idResolver = this.environmentFactory.getIdResolver();
            Class staticType = idResolver.getStaticTypeOf((Object)this.contextObject);
            Class contextType = this.environmentFactory.getMetamodelManager().getPrimaryClass(staticType);
            Package contextPackage = contextType.getOwningPackage();
            IPath documentPath = XtextConsolePlugin.getInstance().getStateLocation().append("debug" + EcoreUtil.generateUUID() + ".ocl");
            IFileStore documentStore = EFS.getLocalFileSystem().getStore(documentPath);
            OutputStream documentStream = documentStore.openOutputStream(0, monitor);
            PrettyPrintOptions.Global printOptions = PrettyPrinter.createOptions(null);
            printOptions.addReservedNames((Iterable)PrettyPrinter.restrictedNameList);
            OutputStreamWriter s = new OutputStreamWriter(documentStream);
            String externalURI = null;
            if (contextPackage != null) {
                Model containingRoot = PivotUtil.getContainingModel((EObject)contextPackage);
                if (containingRoot == null) {
                    externalURI = contextPackage.getURI();
                } else if (containingRoot != PivotUtil.getContainingModel((EObject)this.environmentFactory.getStandardLibrary().getOclAnyType())) {
                    externalURI = containingRoot.getExternalURI();
                }
                if (externalURI != null) {
                    ((Writer)s).append("import '" + externalURI + "'\n\n");
                }
            }
            ((Writer)s).append("context ");
            if (externalURI == null) {
                ((Writer)s).append("ocl::");
            }
            ((Writer)s).append(String.valueOf(PrettyPrinter.printName((Element)contextType, (PrettyPrintOptions)printOptions)) + "\n");
            ((Writer)s).append("def: oclDebuggerExpression() : OclAny = \n\t");
            ((Writer)s).append(this.expression.replace("\n", "\n\t"));
            ((Writer)s).append("\n");
            ((Writer)s).close();
            java.net.URI documentURI1 = documentStore.toURI();
            @NonNull URI documentURI2 = URI.createURI((String)documentURI1.toString());
            return documentURI2;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        protected ILaunch launchDebugger(IProgressMonitor monitor, @Nullable EObject contextObject, @NonNull ExpressionInOCL expressionInOCL) throws CoreException {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance(null, "test");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("expressionObject", expressionInOCL);
            attributes.put("contextObject", contextObject);
            launchConfiguration.setAttributes(attributes);
            return launchConfiguration.launch("debug", monitor);
        }

        protected @Nullable BaseCSResource loadDocument(IProgressMonitor monitor, @NonNull URI documentURI) throws Exception {
            Resource resource;
            Resource contextResource;
            ResourceSet externalResourceSet = this.environmentFactory.getResourceSet();
            if (this.contextObject != null && (contextResource = this.contextObject.eResource()) != null) {
                Map uriResourceMap;
                ResourceSet contextResourceSet = contextResource.getResourceSet();
                if (contextResourceSet != null) {
                    this.environmentFactory.addExternalResources(contextResourceSet);
                } else if (externalResourceSet instanceof ResourceSetImpl && (uriResourceMap = ((ResourceSetImpl)externalResourceSet).getURIResourceMap()) != null) {
                    uriResourceMap.put(contextResource.getURI(), contextResource);
                }
            }
            if ((resource = externalResourceSet.getResource(documentURI, true)) instanceof BaseCSResource) {
                return (BaseCSResource)resource;
            }
            return null;
        }

        protected void openError(final String message) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)shell, (String)ConsoleMessages.Debug_Starter, (String)message);
                }
            });
        }

        protected void openError(final String message, final @NonNull Exception e) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Status status = new Status(4, "org.eclipse.ocl.examples.xtext.console", e.getLocalizedMessage(), (Throwable)e);
                    ErrorDialog.openError((Shell)shell, (String)ConsoleMessages.Debug_Starter, (String)message, (IStatus)status);
                }
            });
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Debug_Starter, (Object)this.expression), 3);
            try {
                ExpressionInOCL query;
                BaseCSResource csResource;
                URI documentURI;
                monitor.subTask(ConsoleMessages.Debug_ProgressCreate);
                try {
                    documentURI = this.createDocument(monitor);
                }
                catch (Exception e) {
                    this.openError(ConsoleMessages.Debug_FailCreate, e);
                    monitor.done();
                    return;
                }
                monitor.worked(1);
                monitor.subTask(ConsoleMessages.Debug_ProgressLoad);
                @NonNull String debug_FailLoad = ConsoleMessages.Debug_FailLoad;
                try {
                    csResource = this.loadDocument(monitor, documentURI);
                }
                catch (Exception e) {
                    this.openError(debug_FailLoad, e);
                    monitor.done();
                    return;
                }
                if (csResource == null) {
                    this.openError(debug_FailLoad);
                    return;
                }
                String message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)csResource.getErrors())), (String)debug_FailLoad, (String)"\n\t");
                if (message != null) {
                    this.openError(message);
                    return;
                }
                try {
                    query = ElementUtil.getFirstQuery((PivotMetamodelManager)this.environmentFactory.getMetamodelManager(), (BaseCSResource)csResource);
                }
                catch (ParserException e) {
                    this.openError(debug_FailLoad, (Exception)((Object)e));
                    monitor.done();
                    return;
                }
                if (query == null) {
                    this.openError(debug_FailLoad);
                    return;
                }
                monitor.worked(1);
                monitor.subTask(ConsoleMessages.Debug_ProgressLoad);
                try {
                    LaunchingUtils.loadPerspectiveManager();
                    this.launch = this.launchDebugger(monitor, this.contextObject, query);
                }
                catch (CoreException e) {
                    this.openError(ConsoleMessages.Debug_FailLaunch, (Exception)((Object)e));
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
    }
}

