/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCommitInfosRequest
extends CDOClientRequest<Boolean> {
    private CDOBranch branch;
    private long startTime;
    private long endTime;
    private CDOCommitInfoHandler handler;

    public LoadCommitInfosRequest(CDOClientProtocol protocol, CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        super(protocol, (short)40);
        this.branch = branch;
        this.startTime = startTime;
        this.endTime = endTime;
        this.handler = handler;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (this.branch == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeCDOBranch(this.branch);
        }
        out.writeLong(this.startTime);
        out.writeLong(this.endTime);
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        InternalCDOCommitInfoManager manager = this.getSession().getCommitInfoManager();
        while (in.readBoolean()) {
            long id = in.readLong();
            CDOBranch branch = this.branch == null ? in.readCDOBranch() : this.branch;
            long timeStamp = in.readLong();
            String userID = in.readString();
            String comment = in.readString();
            try {
                CDOCommitInfo commitInfo = manager.createCommitInfo(branch, timeStamp, id, userID, comment, null);
                this.handler.handleCommitInfo(commitInfo);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        return true;
    }
}

