/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.mobius.transformations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.internal.impl.PackageImpl;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Dependability.StateBased.StateBasedAnalysis.SANAnalysis;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.mobius.handlers.CHESS2SANRunner;
import org.polarsys.chess.mobius.handlers.TransformationHandler;
import org.polarsys.chess.mobius.model.SAN.AtomicNode;
import org.polarsys.chess.mobius.model.SAN.Node;
import org.polarsys.chess.mobius.model.SAN.SANModel;
import org.polarsys.chess.mobius.preferences.Activator;
import org.polarsys.chess.mobius.templates.AtomicComponentTemplate_sanmodel;
import org.polarsys.chess.mobius.templates.ComposedComponentTemplate_sanmodel;
import org.polarsys.chess.mobius.templates.ProjectFileTemplate_sanmodel;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class Transformations {
    public static final String UML_EXT = ".uml";
    private static final String DI_SUFFIX = ".di";
    public static final int NUM_SUB_TASKS = 6;
    public static final String[] PROJECT_SUBFOLDERS = new String[]{"Atomic", "Composed", "Documentation", "Reward", "Solver", "Study", "Transformer"};

    public static void MobiusTransformationJob(final Shell activeShell, final IEditorPart editor, final List<String> args, final String projectName, List<Classifier> atomicBlocks, List<Classifier> composedBlocks, List<Interaction> attackScenarios, Map<Classifier, List<Message>> vulnerableComponents, final SANAnalysis csa, Resource sanRes, final String analysisContextQN, final DiagramStatus chessDiagramStatus, final Resource chessResource) {
        Job job = new Job("CHESS to Mobius Transformation Running"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("operation in progress ...", 6);
                Resource sanResource = null;
                monitor.subTask("generating SAN model...");
                try {
                    sanResource = Transformations.generateSANmodel(editor, csa, analysisContextQN, chessDiagramStatus, chessResource, monitor);
                }
                catch (ExecutionException e1) {
                    e1.printStackTrace();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)activeShell, (String)"CHESS", (String)"Error while generating the SAN model; please check the Error log");
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                monitor.beginTask("operation in progress ...", 5);
                monitor.subTask("setting up project folders...");
                IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
                IFile inputfile = input.getFile();
                final String ProjectRoot = String.valueOf(TransformationHandler.MOBIUS_PROJECT_LOCATION) + File.separator + projectName;
                new File(ProjectRoot).mkdirs();
                monitor.worked(1);
                String[] stringArray = PROJECT_SUBFOLDERS;
                int n = PROJECT_SUBFOLDERS.length;
                int n2 = 0;
                while (n2 < n) {
                    String subfolder = stringArray[n2];
                    new File(String.valueOf(ProjectRoot) + File.separator + subfolder).mkdirs();
                    ++n2;
                }
                String stringToURI = inputfile.getFullPath().toString();
                stringToURI = stringToURI.substring(0, stringToURI.lastIndexOf("."));
                stringToURI = String.valueOf(stringToURI) + Transformations.UML_EXT;
                monitor.worked(1);
                try {
                    SANModel sanModel = (SANModel)sanResource.getContents().get(0);
                    monitor.subTask("transforming SAN model...");
                    monitor.worked(1);
                    monitor.subTask("generating atomic models...");
                    EList nodes = sanModel.getAllNodes();
                    for (Node node : nodes) {
                        if (!(node instanceof AtomicNode)) continue;
                        String targetFolder = String.valueOf(ProjectRoot) + File.separator + "Atomic" + File.separator + node.getName().replaceAll("\\.", "_");
                        new File(targetFolder).mkdirs();
                        File target = new File(targetFolder);
                        args.add(node.getName());
                        AtomicComponentTemplate_sanmodel san = new AtomicComponentTemplate_sanmodel(sanResource.getURI(), target, (List<? extends Object>)args);
                        san.doGenerate(null);
                        args.remove(node.getName());
                    }
                    monitor.worked(1);
                    monitor.subTask("generating composed model...");
                    if (sanModel.getNode() != null) {
                        Node rootNode = sanModel.getNode();
                        String targetFolder = String.valueOf(ProjectRoot) + File.separator + "Composed" + File.separator + rootNode.getName();
                        new File(targetFolder).mkdirs();
                        File target = new File(targetFolder);
                        args.add("");
                        ComposedComponentTemplate_sanmodel cmp = new ComposedComponentTemplate_sanmodel(sanResource.getURI(), target, (List<? extends Object>)args);
                        cmp.doGenerate(null);
                        args.remove("");
                        monitor.worked(1);
                    }
                    monitor.subTask("generating Mobius project file...");
                    File target = new File(ProjectRoot);
                    args.add(projectName);
                    ProjectFileTemplate_sanmodel prj = new ProjectFileTemplate_sanmodel(sanResource.getURI(), target, (List<? extends Object>)args);
                    prj.doGenerate(null);
                    monitor.worked(1);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)activeShell, (String)"CHESS", (String)("Mobius project " + projectName + " has been generated at: " + ProjectRoot));
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)activeShell, (String)"CHESS", (String)"Unexpected problem: check the error log.");
                        }
                    });
                }
                monitor.done();
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
    }

    private static Resource generateSANmodel(IEditorPart editor, SANAnalysis csa, String analysisContextQN, DiagramStatus chessDiagramStatus, Resource resource, IProgressMonitor monitor) throws ExecutionException {
        long startTime;
        CHESS2SANRunner analysisRunner;
        block9: {
            DiagramEditPart diagramEditPart = null;
            try {
                DiagramEditPart csd_ep;
                Object editPart = Transformations.getEditPart();
                diagramEditPart = csd_ep = (DiagramEditPart)editPart;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            IFile file = input.getFile();
            IProject activeProject = file.getProject();
            Path path = new Path(String.valueOf(activeProject.getName()) + "/" + Transformations.changeSuffix(input.getFile().getName(), DI_SUFFIX, UML_EXT));
            URI modelURI = URI.createPlatformResourceURI((String)Transformations.changeSuffix(input.getFile().getFullPath().toString(), DI_SUFFIX, UML_EXT), (boolean)true);
            IFile modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            analysisRunner = new CHESS2SANRunner();
            startTime = System.currentTimeMillis();
            try {
                try {
                    chessDiagramStatus.setUserAction(false);
                    analysisRunner.setModelURI(modelURI);
                    IFolder targetFolder = modelFile.getProject().getFolder("SAN");
                    analysisRunner.setTargetFolder((IContainer)targetFolder);
                    analysisRunner.setDiagramEditPart(diagramEditPart);
                    CHGaResourcePlatform platform = (CHGaResourcePlatform)csa.getPlatform().get(0);
                    analysisRunner.setRootComponent(((PackageImpl)platform.getBase_InstanceSpecification().getOwner()).getQualifiedName());
                    analysisRunner.setAnalysisContextQualifiedName(analysisContextQN);
                    analysisRunner.setChessResource(resource);
                    analysisRunner.run(monitor);
                    activeProject.refreshLocal(2, null);
                }
                catch (InvocationTargetException e) {
                    Status status = new Status(4, "org.polarsys.chess.mobius.preferences", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    throw new ExecutionException("Error during SAN transformation", (Throwable)e);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.polarsys.chess.mobius.preferences", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    throw new ExecutionException("Error during FLA analysis", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Status status = new Status(4, "org.polarsys.chess.mobius.preferences", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    chessDiagramStatus.setUserAction(true);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                chessDiagramStatus.setUserAction(true);
                throw throwable;
            }
            chessDiagramStatus.setUserAction(true);
        }
        long endTime = System.currentTimeMillis();
        CHESSProjectSupport.printlnToCHESSConsole((String)("*** Elapsed time " + (double)(endTime - startTime) / 1000.0 + " s ***"));
        return analysisRunner.getSANResource();
    }

    private static Object getEditPart() {
        Object ep = null;
        try {
            ep = CHESSEditorUtils.getDiagramGraphicalViewer().getRootEditPart().getChildren().get(0);
        }
        catch (Exception exception) {
            return null;
        }
        return ep;
    }

    private static String changeSuffix(String string, String oldSuffix, String newSuffix) {
        String newString = string;
        if (newString.endsWith(oldSuffix)) {
            newString = newString.substring(0, newString.length() - oldSuffix.length());
            newString = String.valueOf(newString) + newSuffix;
        }
        return newString;
    }
}

