/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.mobius.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Dependability.StateBased.StateBasedAnalysis.SANAnalysis;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.mobius.dialogs.AnalysisContextSelectionDialog;
import org.polarsys.chess.mobius.preferences.Activator;
import org.polarsys.chess.mobius.transformations.Transformations;
import org.polarsys.chess.service.gui.utils.CHESSEditorUtils;

public class TransformationHandler
extends AbstractHandler {
    private static final String ANALYSISCONTEXTQN = "CHESS::Dependability::StateBased::StateBasedAnalysis::SANAnalysis";
    public static String MOBIUS_PROJECT_LOCATION = "";
    private Class contextClass;
    private List<Classifier> atomicBlocks;
    private List<Classifier> composedBlocks;
    private List<Interaction> attackScenarios;
    private String projectName;
    private Map<Classifier, List<Message>> vulnerableComponents;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String contextQN;
        SANAnalysis csa;
        Shell activeShell;
        IEditorPart editor;
        block15: {
            block13: {
                Model model;
                block14: {
                    ArrayList<Class> selection;
                    block12: {
                        editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                        activeShell = window.getShell();
                        MOBIUS_PROJECT_LOCATION = Activator.getDefault().getPreferenceStore().getString("Mobius Project Location");
                        File f = new File(MOBIUS_PROJECT_LOCATION);
                        if (!f.exists() || !f.isDirectory()) {
                            MessageDialog.openError((Shell)activeShell, (String)"CHESS", (String)"Mobius Project Location is not valid. Please check preference page");
                            return null;
                        }
                        csa = null;
                        contextQN = null;
                        PapyrusMultiDiagramEditor editorPapyrus = CHESSEditorUtils.getCHESSEditor();
                        Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editorPapyrus.getServicesRegistry());
                        model = ResourceUtils.getModel((Resource)res);
                        selection = new ArrayList<Class>();
                        EList elemList = model.allOwnedElements();
                        for (Element elem : elemList) {
                            if (!(elem instanceof Class) || elem.getAppliedStereotype(ANALYSISCONTEXTQN) == null) continue;
                            selection.add((Class)elem);
                        }
                        if (selection.size() != 0) break block12;
                        MessageDialog.openError((Shell)activeShell, (String)"CHESS", (String)"no suitable analysis contexts in the model");
                        return null;
                    }
                    AnalysisContextSelectionDialog dialog = new AnalysisContextSelectionDialog(activeShell, selection, "Select Security Analysis Context");
                    if (dialog.open() != 0) break block13;
                    contextQN = dialog.getContext();
                    if (contextQN != null && !contextQN.isEmpty()) break block14;
                    return null;
                }
                try {
                    for (Element elem : model.allOwnedElements()) {
                        if (elem.getAppliedStereotype(ANALYSISCONTEXTQN) == null || !((NamedElement)elem).getQualifiedName().equals(contextQN)) continue;
                        this.contextClass = (Class)elem;
                    }
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
            Stereotype stereo = this.contextClass.getAppliedStereotype(ANALYSISCONTEXTQN);
            csa = (SANAnalysis)this.contextClass.getStereotypeApplication(stereo);
            if (csa.getPlatform().size() > 0) {
                if (csa.getPlatform().get(0) instanceof CHGaResourcePlatform) {
                    CHGaResourcePlatform platform = (CHGaResourcePlatform)csa.getPlatform().get(0);
                    this.projectName = ((Classifier)platform.getBase_InstanceSpecification().getClassifiers().get(0)).getName();
                }
                break block15;
            }
            MessageDialog.openError((Shell)activeShell, (String)"CHESS", (String)"no platform is defined in the selected analysis context");
            return null;
        }
        PapyrusMultiDiagramEditor papyrusEditor = CHESSEditorUtils.getCHESSEditor();
        DiagramStatus ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)papyrusEditor);
        Resource resource = null;
        try {
            resource = ResourceUtils.getUMLResource((ServicesRegistry)papyrusEditor.getServicesRegistry());
        }
        catch (ServiceException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)activeShell, (String)"CHESS", (String)"Problems with the Papyrus registry editor");
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        Transformations.MobiusTransformationJob(activeShell, editor, args, this.projectName, this.atomicBlocks, this.composedBlocks, this.attackScenarios, this.vulnerableComponents, csa, null, contextQN, ds, resource);
        return null;
    }
}

