/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.dialogs;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Property;
import org.polarsys.chess.contracts.profile.chesscontract.ComponentInstance;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;
import org.polarsys.chess.contracts.profile.chesscontract.DataTypes.ContractTypes;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;

public class SetContractRefinementDialog
extends Dialog {
    String RANGE_EXCEPTION = "The ranges of the indexes of subcomponents must be delimited with ','. The format of each range is 'lowerValue..upperValue'. For example: : 1..4,7..n";
    private Set<Integer> selectedContractRefinementIndexes = new HashSet<Integer>();
    private ArrayList<ContractRefinementObj> refineList = new ArrayList();
    private Class ownerClass;
    private ArrayList<ContractRefinementObj> selectedContractRefinementObjs;
    private ArrayList<Text> rangeTexts = new ArrayList();
    private EList<ContractRefinement> refinedByList;
    Table table;
    Label tableLabel;
    TableColumn columnCheckBoxes;
    TableColumn columnContracts;
    TableColumn columnRanges;
    Composite composite;

    public SetContractRefinementDialog(Shell shell, Class ownerClass, EList<ContractRefinement> refineList) {
        super(shell);
        this.ownerClass = ownerClass;
        this.refinedByList = refineList;
    }

    private void populateRefineList() throws Exception {
        this.refineList.clear();
        for (Property subComponentInstance : EntityUtil.getInstance().getSubComponentsInstances(this.ownerClass)) {
            String[] range = EntityUtil.getInstance().getAttributeMultiplicity((MultiplicityElement)subComponentInstance);
            if (range[0] != null && range[1] != null && range[0].compareTo(range[1]) != 0) {
                throw new Exception("The multiplicity of the subcomponent " + subComponentInstance.getName() + " should not be a range. Please set a unique value for the upper and lower ranges.");
            }
            for (ContractProperty contractProperty : ContractEntityUtil.getInstance().getContractProperties((Class)subComponentInstance.getType())) {
                if (!contractProperty.getContractType().equals((Object)ContractTypes.STRONG)) continue;
                this.refineList.add(new ContractRefinementObj(subComponentInstance.getName(), contractProperty.getBase_Property().getName(), range[0], range[1]));
            }
            if (subComponentInstance.getAppliedStereotype("CHESSContract::ComponentInstance") == null) continue;
            ComponentInstance compInst = (ComponentInstance)subComponentInstance.getStereotypeApplication(subComponentInstance.getAppliedStereotype("CHESSContract::ComponentInstance"));
            for (ContractProperty contractProperty : compInst.getWeakGuarantees()) {
                this.refineList.add(new ContractRefinementObj(subComponentInstance.getName(), contractProperty.getBase_Property().getName(), range[0], range[1]));
            }
        }
        if (this.refineList.size() == 0) {
            throw new Exception("No refining contracts available in the sub-components");
        }
    }

    public void populateRefineListAndCreateDialog() throws Exception {
        this.populateRefineList();
        super.create();
        this.composite.redraw();
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = parent;
        this.rangeTexts.clear();
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        this.tableLabel = new Label(parent, 0);
        this.tableLabel.setText("Select Refinements:");
        this.tableLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.table = new Table(parent, 65552);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.columnCheckBoxes = new TableColumn(this.table, 4);
        this.columnContracts = new TableColumn(this.table, 4);
        this.columnRanges = new TableColumn(this.table, 4);
        int index = 0;
        for (ContractRefinementObj contractRefinement : this.refineList) {
            Button checkButton = new Button((Composite)this.table, 32);
            checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button btn = (Button)event.getSource();
                    int selectedIndex = (Integer)btn.getData();
                    if (btn.getSelection()) {
                        SetContractRefinementDialog.this.selectedContractRefinementIndexes.add(selectedIndex);
                    } else {
                        SetContractRefinementDialog.this.selectedContractRefinementIndexes.remove(selectedIndex);
                    }
                }
            });
            checkButton.pack();
            checkButton.setData((Object)index);
            ++index;
            String rangeStr = contractRefinement.getRangeStr(true);
            TableItem contractName = new TableItem(this.table, 0);
            contractName.setText(1, String.valueOf(contractRefinement.getSubComponentName()) + rangeStr + "." + contractRefinement.getContractName());
            TableEditor editor = new TableEditor(this.table);
            editor.horizontalAlignment = 0x1000000;
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)checkButton, contractName, 0);
            Text selectedRange = new Text((Composite)this.table, 16384);
            this.rangeTexts.add(selectedRange);
            this.updateGUIExistingRefiningContracts(checkButton, contractRefinement, selectedRange);
            if (contractRefinement.getLower() != null && contractRefinement.getUpper() != null) {
                if (selectedRange.getText().equals("")) {
                    String rangeStrToEdit = contractRefinement.getRangeStr(false);
                    selectedRange.setText(rangeStrToEdit);
                }
            } else {
                selectedRange.setEnabled(false);
            }
            editor = new TableEditor(this.table);
            editor.minimumWidth = 100;
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)selectedRange, contractName, 2);
        }
        this.columnCheckBoxes.pack();
        this.columnCheckBoxes.setWidth(Math.max(this.columnCheckBoxes.getWidth(), 26));
        this.columnContracts.setText("contract");
        this.columnContracts.pack();
        this.columnRanges.setText("range");
        this.columnRanges.pack();
        this.columnRanges.setWidth(Math.max(this.columnRanges.getWidth(), 60));
        final float columnRatio = (float)this.columnContracts.getWidth() / (float)this.columnRanges.getWidth();
        this.composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SetContractRefinementDialog.this.refreshTableSize(columnRatio);
            }
        });
        GridData tableGridData = new GridData(4, 4, true, true);
        tableGridData.heightHint = this.table.getItemHeight() * (this.table.getItemCount() + 1) + 10;
        this.table.setLayoutData((Object)tableGridData);
        this.composite.redraw();
        return parent;
    }

    private void refreshTableSize(float columnRatio) {
        Rectangle area = this.composite.getClientArea();
        if (area.width != this.table.getSize().x) {
            this.columnRanges.setWidth(Math.round((float)(area.width - this.columnCheckBoxes.getWidth()) / (columnRatio + 1.0f)));
            this.columnContracts.setWidth(area.width - this.columnCheckBoxes.getWidth() - this.columnRanges.getWidth());
        }
    }

    private void updateGUIExistingRefiningContracts(Button checkButton, ContractRefinementObj contractRefinement, Text selectedRange) {
        for (ContractRefinement contractRef : this.refinedByList) {
            if (contractRef.getInstance().getName().compareTo(contractRefinement.getSubComponentName()) != 0 || contractRef.getContract().getBase_Property().getName().compareTo(contractRefinement.getContractName()) != 0) continue;
            checkButton.setSelection(true);
            int selectedIndex = (Integer)checkButton.getData();
            this.selectedContractRefinementIndexes.add(selectedIndex);
            if (contractRefinement.getLower() == null || contractRefinement.getUpper() == null) continue;
            if (!selectedRange.getText().equals("")) {
                selectedRange.setText(String.valueOf(selectedRange.getText()) + ",");
            }
            selectedRange.setText(String.valueOf(selectedRange.getText()) + contractRef.getLowerIndexOfInstance() + ".." + contractRef.getUpperIndexOfInstance());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Set Contract Refinement");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000008, 0x1000008, true, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void okPressed() {
        this.selectedContractRefinementObjs = new ArrayList();
        for (int selIndex : this.selectedContractRefinementIndexes) {
            Text text = this.rangeTexts.get(selIndex);
            if (text.isEnabled()) {
                ContractRefinementObj contractRefinementObj = this.refineList.get(selIndex);
                String[][] ranges = null;
                try {
                    ranges = this.extractRanges(text.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DialogUtil.getInstance().showMessage_ExceptionError(e);
                }
                String[][] stringArray = ranges;
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] range = stringArray[n2];
                    ContractRefinementObj newContractRefinementObj = new ContractRefinementObj(contractRefinementObj.getSubComponentName(), contractRefinementObj.getContractName(), range[0], range[1]);
                    this.selectedContractRefinementObjs.add(newContractRefinementObj);
                    ++n2;
                }
                continue;
            }
            this.selectedContractRefinementObjs.add(this.refineList.get(selIndex));
        }
        super.okPressed();
    }

    private String[][] extractRanges(String text) throws Exception {
        if (text == "") {
            throw new Exception(this.RANGE_EXCEPTION);
        }
        String[] ranges = text.split(",");
        String[][] res = new String[ranges.length][2];
        int i = 0;
        while (i < ranges.length) {
            String[] uppLowRange = ranges[i].split("\\.\\.");
            if (uppLowRange.length != 2) {
                throw new Exception(this.RANGE_EXCEPTION);
            }
            res[i][0] = uppLowRange[0];
            res[i][1] = uppLowRange[1];
            ++i;
        }
        return res;
    }

    public ArrayList<ContractRefinementObj> getSelected() {
        return this.selectedContractRefinementObjs;
    }

    public class ContractRefinementObj {
        String subComponentName;
        String contractName;
        String lower;
        String upper;

        public ContractRefinementObj(String subComponentName, String contractName, String lower, String upper) {
            this.subComponentName = subComponentName;
            this.contractName = contractName;
            this.lower = lower;
            this.upper = upper;
        }

        public String getSubComponentName() {
            return this.subComponentName;
        }

        public String getContractName() {
            return this.contractName;
        }

        public String getLower() {
            return this.lower;
        }

        public String getUpper() {
            return this.upper;
        }

        public String getID() {
            String optRange = "";
            if (this.lower != null && this.upper != null) {
                optRange = String.valueOf(this.lower) + "_" + this.upper + ".";
            }
            return String.valueOf(this.subComponentName) + "." + optRange + this.contractName;
        }

        public String getRangeStr(boolean withBrackets) {
            if (this.getLower() != null && this.getUpper() != null) {
                String res = this.getUpper().compareTo(this.getLower()) == 0 ? "0..(" + this.getUpper() + " - 1)" : String.valueOf(this.getLower()) + ".." + this.getUpper();
                if (withBrackets) {
                    return "[" + res + "]";
                }
                return res;
            }
            return "";
        }
    }
}

